/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.Fluids;
import forestry.core.fluids.ITankManager;
import forestry.core.fluids.ITankUpdateHandler;
import forestry.core.fluids.StandardTank;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.packets.PacketTankLevelUpdate;
import forestry.core.render.EnumTankLevel;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.IRenderableTile;
import forestry.core.utils.NBTUtilForestry;
import forestry.core.utils.NetworkUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.FluidTankPropertiesWrapper;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;

public class TankManager
implements ITankManager,
ITankUpdateHandler,
IStreamable,
INbtWritable,
INbtReadable {
    private final List<StandardTank> tanks = new ArrayList<StandardTank>();
    private final Table<Container, Integer, FluidStack> prevFluidStacks = HashBasedTable.create();
    @Nullable
    private final ILiquidTankTile tile;
    private final List<EnumTankLevel> tankLevels = new ArrayList<EnumTankLevel>();

    public TankManager() {
        this.tile = null;
    }

    public TankManager(ILiquidTankTile tile, StandardTank ... tanks) {
        this.tile = tile;
        this.addAll(Arrays.asList(tanks));
    }

    public final boolean addAll(Collection<? extends StandardTank> collection) {
        boolean addedAll = true;
        for (StandardTank standardTank : collection) {
            addedAll &= this.add(standardTank);
        }
        return addedAll;
    }

    public boolean add(StandardTank tank) {
        boolean added = this.tanks.add(tank);
        int index = this.tanks.indexOf(tank);
        tank.setTankUpdateHandler(this);
        tank.setTankIndex(index);
        this.tankLevels.add(EnumTankLevel.rateTankLevel((IFluidTank)tank));
        return added;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        NBTTagList tagList = new NBTTagList();
        for (byte slot = 0; slot < this.tanks.size(); slot = (byte)((byte)(slot + 1))) {
            StandardTank tank = this.tanks.get(slot);
            if (tank.getFluid() == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("tank", slot);
            tank.writeToNBT(tag);
            tagList.func_74742_a((NBTBase)tag);
        }
        data.func_74782_a("tanks", (NBTBase)tagList);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        NBTUtilForestry.NBTList tagList = NBTUtilForestry.getNBTList(data, "tanks", NBTUtilForestry.EnumNBTType.COMPOUND);
        Iterator iterator = tagList.iterator();
        while (iterator.hasNext()) {
            NBTTagCompound tag = (NBTTagCompound)iterator.next();
            byte slot = tag.func_74771_c("tank");
            if (slot < 0 || slot >= this.tanks.size()) continue;
            StandardTank tank = this.tanks.get(slot);
            tank.readFromNBT(tag);
            this.updateTankLevels(tank, false);
        }
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        for (StandardTank tank : this.tanks) {
            tank.writeData(data);
        }
    }

    @Override
    public void readData(PacketBufferForestry data) throws IOException {
        for (StandardTank tank : this.tanks) {
            tank.readData(data);
        }
    }

    @Override
    public void containerAdded(Container container, IContainerListener player) {
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        List<IContainerListener> crafters = Collections.singletonList(player);
        for (StandardTank tank : this.tanks) {
            this.sendTankUpdate(container, crafters, tank);
        }
    }

    @Override
    public void containerRemoved(Container container) {
        for (StandardTank tank : this.tanks) {
            this.prevFluidStacks.remove((Object)container, (Object)tank.getTankIndex());
        }
    }

    @Override
    public void sendTankUpdate(Container container, List<IContainerListener> crafters) {
        for (StandardTank tank : this.tanks) {
            this.sendTankUpdate(container, crafters, tank.getTankIndex());
        }
    }

    private void sendTankUpdate(Container container, List<IContainerListener> crafters, int tankIndex) {
        FluidStack prev;
        StandardTank tank = this.tanks.get(tankIndex);
        if (tank == null) {
            return;
        }
        FluidStack fluidStack = tank.getFluid();
        if (FluidHelper.areFluidStacksEqual(fluidStack, prev = (FluidStack)this.prevFluidStacks.get((Object)container, (Object)tankIndex))) {
            return;
        }
        this.sendTankUpdate(container, crafters, tank);
    }

    private void sendTankUpdate(Container container, Iterable<IContainerListener> crafters, StandardTank tank) {
        if (this.tile != null) {
            int tankIndex = tank.getTankIndex();
            FluidStack fluid = tank.getFluid();
            PacketTankLevelUpdate packet = new PacketTankLevelUpdate(this.tile, tankIndex, fluid);
            for (IContainerListener crafter : crafters) {
                if (!(crafter instanceof EntityPlayerMP)) continue;
                NetworkUtil.sendToPlayer(packet, (EntityPlayer)((EntityPlayerMP)crafter));
            }
            if (fluid == null) {
                this.prevFluidStacks.remove((Object)container, (Object)tankIndex);
            } else {
                this.prevFluidStacks.put((Object)container, (Object)tankIndex, (Object)fluid.copy());
            }
        }
    }

    @Override
    public void processTankUpdate(int tankIndex, @Nullable FluidStack contents) {
        if (tankIndex < 0 || tankIndex > this.tanks.size()) {
            return;
        }
        StandardTank tank = this.tanks.get(tankIndex);
        tank.setFluid(contents);
    }

    @Override
    public IFluidTank getTank(int tankIndex) {
        return (IFluidTank)this.tanks.get(tankIndex);
    }

    public int fill(FluidStack resource, boolean doFill) {
        for (StandardTank tank : this.tanks) {
            if (!TankManager.tankAcceptsFluid(tank, resource)) continue;
            return this.fill(tank.getTankIndex(), resource, doFill);
        }
        return EmptyFluidHandler.INSTANCE.fill(resource, doFill);
    }

    public int fill(int tankIndex, FluidStack resource, boolean doFill) {
        if (tankIndex < 0 || tankIndex >= this.tanks.size()) {
            return 0;
        }
        StandardTank tank = this.tanks.get(tankIndex);
        if (!tank.canFill()) {
            return 0;
        }
        return tank.fill(resource, doFill);
    }

    @Override
    public void updateTankLevels(StandardTank tank) {
        this.updateTankLevels(tank, true);
    }

    private void updateTankLevels(StandardTank tank, boolean sendUpdate) {
        if (!(this.tile instanceof IRenderableTile)) {
            return;
        }
        int tankIndex = tank.getTankIndex();
        EnumTankLevel tankLevel = EnumTankLevel.rateTankLevel((IFluidTank)tank);
        if (tankLevel != this.tankLevels.get(tankIndex)) {
            this.tankLevels.set(tankIndex, tankLevel);
            if (sendUpdate) {
                PacketTankLevelUpdate tankLevelUpdate = new PacketTankLevelUpdate(this.tile, tankIndex, tank.getFluid());
                NetworkUtil.sendNetworkPacket(tankLevelUpdate, this.tile.getCoordinates(), this.tile.getWorldObj());
            }
        }
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        for (StandardTank tank : this.tanks) {
            if (!TankManager.tankCanDrain(tank)) continue;
            return this.drain(tank.getTankIndex(), maxDrain, doDrain);
        }
        return EmptyFluidHandler.INSTANCE.drain(maxDrain, doDrain);
    }

    @Nullable
    public FluidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        if (tankIndex < 0 || tankIndex >= this.tanks.size()) {
            return null;
        }
        StandardTank tank = this.tanks.get(tankIndex);
        if (!tank.canDrain()) {
            return null;
        }
        return tank.drain(maxDrain, doDrain);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        for (StandardTank tank : this.tanks) {
            if (!TankManager.tankCanDrainFluid(tank, resource)) continue;
            return this.drain(tank.getTankIndex(), resource.amount, doDrain);
        }
        return null;
    }

    public IFluidTankProperties[] getTankProperties() {
        IFluidTankProperties[] properties = new IFluidTankProperties[this.tanks.size()];
        for (int i = 0; i < this.tanks.size(); ++i) {
            properties[i] = new FluidTankPropertiesWrapper((FluidTank)this.tanks.get(i));
        }
        return properties;
    }

    public FluidTankInfo getTankInfo(int tankIndex) {
        return this.tanks.get(tankIndex).getInfo();
    }

    @Nullable
    public FluidStack getFluid(int tankIndex) {
        return this.tanks.get(tankIndex).getFluid();
    }

    public int getFluidAmount(int tankIndex) {
        return this.tanks.get(tankIndex).getFluidAmount();
    }

    @Override
    public boolean canFillFluidType(FluidStack fluidStack) {
        for (StandardTank tank : this.tanks) {
            if (!tank.canFillFluidType(fluidStack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canDrainFluidType(FluidStack fluidStack) {
        for (StandardTank tank : this.tanks) {
            if (!tank.canDrainFluidType(fluidStack)) continue;
            return true;
        }
        return false;
    }

    private static boolean tankAcceptsFluid(StandardTank tank, FluidStack fluidStack) {
        return tank.canFill() && tank.fill(fluidStack, false) > 0;
    }

    private static boolean tankCanDrain(StandardTank tank) {
        if (!tank.canDrain()) {
            return false;
        }
        FluidStack drained = tank.drain(1, false);
        return drained != null && drained.amount > 0;
    }

    private static boolean tankCanDrainFluid(StandardTank tank, FluidStack fluidStack) {
        return Fluids.areEqual(tank.getFluidType(), fluidStack) && TankManager.tankCanDrain(tank);
    }
}

