/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import com.mojang.authlib.GameProfile;
import forestry.api.world.ITreeGenData;
import forestry.arboriculture.blocks.BlockSapling;
import forestry.arboriculture.tiles.TileTreeContainer;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.TopDownBlockPosComparator;
import forestry.core.worldgen.WorldGenBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.TerrainGen;

public abstract class WorldGenArboriculture
extends WorldGenBase {
    protected static final int minPodHeight = 3;
    protected final ITreeGenData tree;

    protected WorldGenArboriculture(ITreeGenData tree) {
        this.tree = tree;
    }

    @Override
    public boolean generate(World world, Random rand, BlockPos pos, boolean forced) {
        if (!TerrainGen.saplingGrowTree((World)world, (Random)rand, (BlockPos)pos)) {
            return false;
        }
        GameProfile owner = WorldGenArboriculture.getOwner(world, pos);
        TreeBlockTypeLeaf leaf = new TreeBlockTypeLeaf(this.tree, owner, rand);
        TreeBlockTypeLog wood = new TreeBlockTypeLog(this.tree);
        this.preGenerate(world, rand, pos);
        BlockPos genPos = forced ? pos : this.getValidGrowthPos(world, pos);
        if (genPos != null) {
            this.clearSaplings(world, genPos);
            ArrayList<BlockPos> branchEnds = new ArrayList<BlockPos>(this.generateTrunk(world, rand, wood, genPos));
            branchEnds.sort(TopDownBlockPosComparator.INSTANCE);
            this.generateLeaves(world, rand, leaf, branchEnds, genPos);
            this.generateExtras(world, rand, genPos);
            return true;
        }
        return false;
    }

    @Nullable
    private static GameProfile getOwner(World world, BlockPos pos) {
        TileTreeContainer tile = TileUtil.getTile((IBlockAccess)world, pos, TileTreeContainer.class);
        if (tile == null) {
            return null;
        }
        return tile.getOwnerHandler().getOwner();
    }

    public void preGenerate(World world, Random rand, BlockPos startPos) {
    }

    protected abstract Set<BlockPos> generateTrunk(World var1, Random var2, TreeBlockTypeLog var3, BlockPos var4);

    protected abstract void generateLeaves(World var1, Random var2, TreeBlockTypeLeaf var3, List<BlockPos> var4, BlockPos var5);

    protected abstract void generateExtras(World var1, Random var2, BlockPos var3);

    @Nullable
    public abstract BlockPos getValidGrowthPos(World var1, BlockPos var2);

    public void clearSaplings(World world, BlockPos genPos) {
        int treeGirth = this.tree.getGirth();
        for (int x = 0; x < treeGirth; ++x) {
            for (int z = 0; z < treeGirth; ++z) {
                BlockPos saplingPos = genPos.func_177982_a(x, 0, z);
                if (!(world.func_180495_p(saplingPos).func_177230_c() instanceof BlockSapling)) continue;
                world.func_175698_g(saplingPos);
            }
        }
    }

    public boolean hasPods() {
        return this.tree.allowsFruitBlocks();
    }
}

