/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.alleles.AlleleEffectThrottled;
import forestry.core.genetics.EffectData;
import forestry.core.utils.VectUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class AlleleEffectFungification
extends AlleleEffectThrottled {
    private static final int MAX_BLOCK_FIND_TRIES = 10;
    private static final int ENTITY_THROTTLE = 6;

    public AlleleEffectFungification() {
        super("mycophilic", true, 20, false, false);
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (storedData instanceof EffectData && ((EffectData)storedData).getIntSize() == 2) {
            return storedData;
        }
        return new EffectData(2, 0);
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        this.doBlockEffect(genome, housing);
        int entityThrottle = storedData.getInteger(1);
        if (entityThrottle >= 6) {
            AlleleEffectFungification.doEntityEffect(genome, housing);
            entityThrottle = 0;
        } else {
            ++entityThrottle;
        }
        storedData.setInteger(1, entityThrottle);
        return storedData;
    }

    private void doBlockEffect(IBeeGenome genome, IBeeHousing housing) {
        World world = housing.getWorldObj();
        BlockPos housingCoordinates = housing.getCoordinates();
        Vec3i area = AlleleEffectFungification.getModifiedArea(genome, housing);
        Vec3i halfArea = new Vec3i(area.func_177958_n() / 2, area.func_177956_o() / 2, area.func_177952_p() / 2);
        for (int attempt = 0; attempt < 10; ++attempt) {
            BlockPos pos = VectUtil.getRandomPositionInArea(world.field_73012_v, area).func_177973_b(halfArea).func_177971_a((Vec3i)housingCoordinates);
            if (!world.func_175667_e(pos)) continue;
            IBlockState blockState = world.func_180495_p(pos);
            if (AlleleEffectFungification.convertToMycelium(world, blockState, pos)) {
                return;
            }
            if (!AlleleEffectFungification.growGiantMushroom(world, blockState, pos)) continue;
            return;
        }
    }

    private static void doEntityEffect(IBeeGenome genome, IBeeHousing housing) {
        List<EntityCow> cows = AlleleEffectFungification.getEntitiesInRange(genome, housing, EntityCow.class);
        for (EntityCow cow : cows) {
            if (!AlleleEffectFungification.convertCowToMooshroom(cow)) continue;
            return;
        }
    }

    private static boolean convertToMycelium(World world, IBlockState blockState, BlockPos pos) {
        Block block = blockState.func_177230_c();
        if (block == Blocks.field_150349_c || block == Blocks.field_150346_d && world.func_175710_j(pos)) {
            world.func_175656_a(pos, Blocks.field_150391_bh.func_176223_P());
            return true;
        }
        return false;
    }

    private static boolean growGiantMushroom(World world, IBlockState blockState, BlockPos pos) {
        Block block = blockState.func_177230_c();
        if (block instanceof BlockMushroom) {
            BlockMushroom mushroom = (BlockMushroom)block;
            mushroom.func_176485_d(world, pos, blockState, world.field_73012_v);
            return true;
        }
        return false;
    }

    private static boolean convertCowToMooshroom(EntityCow cow) {
        if (cow instanceof EntityMooshroom) {
            return false;
        }
        World world = cow.field_70170_p;
        cow.func_70106_y();
        EntityMooshroom mooshroom = new EntityMooshroom(world);
        mooshroom.func_70012_b(cow.field_70165_t, cow.field_70163_u, cow.field_70161_v, cow.field_70177_z, cow.field_70125_A);
        mooshroom.func_70606_j(cow.func_110143_aJ());
        mooshroom.field_70761_aq = cow.field_70761_aq;
        world.func_72838_d((Entity)mooshroom);
        world.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, cow.field_70165_t, cow.field_70163_u + (double)(cow.field_70131_O / 2.0f), cow.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        return true;
    }
}

