/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.itemblacklist.data;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.doubledoordev.itemblacklist.Helper;
import net.doubledoordev.itemblacklist.data.BanListEntry;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class BanList {
    public final Multimap<Item, BanListEntry> banListEntryMap = HashMultimap.create();
    private String dimension;

    public BanList(String dimension) {
        this.setDimension(dimension);
        if (!"__GLOBAL__".equals(dimension)) {
            this.getDimIds();
        }
    }

    private BanList() {
    }

    public boolean isBanned(ItemStack itemStack) {
        for (BanListEntry banListEntry : this.banListEntryMap.get((Object)itemStack.func_77973_b())) {
            if (!banListEntry.isBanned(itemStack.func_77952_i())) continue;
            return true;
        }
        return false;
    }

    public int[] getDimIds() {
        return Helper.parseDimIds(this.dimension);
    }

    public String getDimension() {
        return this.dimension;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension.replaceAll(" ", "");
    }

    public static class Json
    implements JsonSerializer<BanList>,
    JsonDeserializer<BanList> {
        public BanList deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            BanList banList = new BanList();
            for (JsonElement element : json.getAsJsonArray()) {
                BanListEntry entry = (BanListEntry)context.deserialize(element, BanListEntry.class);
                if (banList.banListEntryMap.containsValue((Object)entry)) {
                    throw new IllegalArgumentException("Duplicate ban list entry.");
                }
                banList.banListEntryMap.put((Object)entry.getItem(), (Object)entry);
            }
            return banList;
        }

        public JsonElement serialize(BanList src, Type typeOfSrc, JsonSerializationContext context) {
            JsonArray array = new JsonArray();
            for (BanListEntry banList : src.banListEntryMap.values()) {
                array.add(context.serialize((Object)banList));
            }
            return array;
        }
    }
}

