/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.laggoggles.client.gui;

import com.github.terminatornl.laggoggles.client.ServerDataPacketHandler;
import com.github.terminatornl.laggoggles.client.gui.GuiScanResultsWorld;
import com.github.terminatornl.laggoggles.packet.ObjectData;
import com.github.terminatornl.laggoggles.profiler.ProfileResult;
import com.github.terminatornl.laggoggles.profiler.ScanType;
import com.github.terminatornl.laggoggles.profiler.TimingManager;
import com.github.terminatornl.laggoggles.util.Calculations;
import com.github.terminatornl.laggoggles.util.Graphical;
import com.github.terminatornl.laggoggles.util.Perms;
import java.io.IOException;
import java.util.Collections;
import java.util.TreeSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.client.GuiScrollingList;

public class GuiEventTypes
extends GuiScrollingList {
    private final FontRenderer FONTRENDERER;
    private static final int slotHeight = 24;
    private int COLUMN_WIDTH_NANOS = 0;
    private TreeSet<GuiScanResultsWorld.LagSource> DATA = new TreeSet(Collections.reverseOrder());
    private final ProfileResult result;

    public GuiEventTypes(Minecraft client, int width, int height, int top, int bottom, int left, int screenWidth, int screenHeight, ProfileResult result) {
        super(client, width, height, top, bottom, left, 24, screenWidth, screenHeight);
        this.FONTRENDERER = client.field_71466_p;
        this.result = result;
        for (GuiScanResultsWorld.LagSource src : result.getLagSources()) {
            if (src.data.type != ObjectData.Type.EVENT_BUS_LISTENER) continue;
            TimingManager.EventTimings.ThreadType type = TimingManager.EventTimings.ThreadType.values()[(Integer)src.data.getValue(ObjectData.Entry.EVENT_BUS_THREAD_TYPE)];
            if ((result.getType() != ScanType.FPS || type != TimingManager.EventTimings.ThreadType.CLIENT) && (result.getType() != ScanType.WORLD || type == TimingManager.EventTimings.ThreadType.CLIENT) || ((String)src.data.getValue(ObjectData.Entry.EVENT_BUS_LISTENER)).contains("LagGoggles") && ((String)src.data.getValue(ObjectData.Entry.EVENT_BUS_EVENT_CLASS_NAME)).equals(Graphical.formatClassName(RenderGameOverlayEvent.Post.class.toString()))) continue;
            this.DATA.add(src);
            this.COLUMN_WIDTH_NANOS = Math.max(this.COLUMN_WIDTH_NANOS, this.FONTRENDERER.func_78256_a(this.getMuStringFor(src)));
        }
    }

    protected int getSize() {
        if (!ServerDataPacketHandler.NON_OPS_CAN_SEE_EVENT_SUBSCRIBERS && this.result.getType() == ScanType.WORLD && ServerDataPacketHandler.PERMISSION.ordinal() < Perms.Permission.FULL.ordinal()) {
            return 1;
        }
        return this.DATA.size();
    }

    protected void elementClicked(int slot, boolean doubleClick) {
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        super.drawScreen(mouseX, mouseY, partialTicks);
    }

    protected boolean isSelected(int index) {
        return false;
    }

    protected void drawBackground() {
    }

    public void handleMouseInput() throws IOException {
        super.handleMouseInput(this.left, this.top);
    }

    public void displayCantSeeResults(int slotTop) {
        this.drawString("You can't see these results because the", this.left + 10, slotTop, 0x4C4C4C);
        this.drawString("server has disabled it in their config.", this.left + 10, slotTop + 12, 0x4C4C4C);
    }

    protected void drawSlot(int slot, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
        int percentOffSet;
        if (!ServerDataPacketHandler.NON_OPS_CAN_SEE_EVENT_SUBSCRIBERS && this.result.getType() == ScanType.WORLD && ServerDataPacketHandler.PERMISSION.ordinal() < Perms.Permission.FULL.ordinal()) {
            this.displayCantSeeResults(slotTop);
            return;
        }
        if (slot > this.DATA.size()) {
            return;
        }
        GuiScanResultsWorld.LagSource lagSource = this.DATA.descendingSet().toArray(new GuiScanResultsWorld.LagSource[0])[slot];
        int threadColor = 65280;
        String threadType = "(Asynchronous)";
        switch (TimingManager.EventTimings.ThreadType.values()[(Integer)lagSource.data.getValue(ObjectData.Entry.EVENT_BUS_THREAD_TYPE)]) {
            case CLIENT: {
                threadType = "(Gui thread)";
                threadColor = 0xFF0000;
                break;
            }
            case SERVER: {
                threadType = "(Server thread)";
                threadColor = 0xFF0000;
            }
        }
        double heat = Calculations.heatThread(lagSource, this.result);
        double[] RGB = Graphical.heatToColor(heat);
        int color = Graphical.RGBtoInt(RGB);
        this.drawStringToLeftOf(this.getMuStringFor(lagSource), this.left + this.COLUMN_WIDTH_NANOS + 5, slotTop, color);
        String percentString = this.getPercentStringFor(lagSource);
        this.drawString(percentString, this.left + this.COLUMN_WIDTH_NANOS + 10, slotTop, color);
        int offSet = percentOffSet = this.FONTRENDERER.func_78256_a(percentString);
        String listener = (String)lagSource.data.getValue(ObjectData.Entry.EVENT_BUS_LISTENER);
        this.drawString(listener, this.left + this.COLUMN_WIDTH_NANOS + 10 + offSet + 5, slotTop, 0x4C4C4C);
        this.drawString(threadType, this.left + this.COLUMN_WIDTH_NANOS + 10 + (offSet += this.FONTRENDERER.func_78256_a(listener)) + 10, slotTop, threadColor);
        this.drawString((String)lagSource.data.getValue(ObjectData.Entry.EVENT_BUS_EVENT_CLASS_NAME), this.left + this.COLUMN_WIDTH_NANOS + 10 + percentOffSet + 5, slotTop + 12, 0x4C4C4C);
    }

    private String getMuStringFor(GuiScanResultsWorld.LagSource source) {
        TimingManager.EventTimings.ThreadType type = TimingManager.EventTimings.ThreadType.values()[(Integer)source.data.getValue(ObjectData.Entry.EVENT_BUS_THREAD_TYPE)];
        if (type == TimingManager.EventTimings.ThreadType.CLIENT) {
            return Calculations.NFStringSimple(source.nanos, this.result.getTotalFrames());
        }
        if (type == TimingManager.EventTimings.ThreadType.ASYNC) {
            return "No impact";
        }
        if (type == TimingManager.EventTimings.ThreadType.SERVER) {
            return Calculations.muPerTickString(source.nanos, this.result);
        }
        throw new IllegalStateException("Terminator_NL forgot to add code here... Please submit an issue at github!");
    }

    private String getPercentStringFor(GuiScanResultsWorld.LagSource source) {
        TimingManager.EventTimings.ThreadType type = TimingManager.EventTimings.ThreadType.values()[(Integer)source.data.getValue(ObjectData.Entry.EVENT_BUS_THREAD_TYPE)];
        if (type == TimingManager.EventTimings.ThreadType.CLIENT) {
            return Calculations.nfPercent(source.nanos, this.result);
        }
        if (type == TimingManager.EventTimings.ThreadType.ASYNC) {
            return "";
        }
        if (type == TimingManager.EventTimings.ThreadType.SERVER) {
            return Calculations.tickPercent(source.nanos, this.result);
        }
        throw new IllegalStateException("Terminator_NL forgot to add code here... Please submit an issue at github!");
    }

    private void drawString(String text, int x, int y, int color) {
        this.FONTRENDERER.func_175063_a(text, (float)x, (float)y, color);
    }

    private void drawStringToLeftOf(String text, int right, int y, int color) {
        this.FONTRENDERER.func_175063_a(text, (float)(right - this.FONTRENDERER.func_78256_a(text)), (float)y, color);
    }
}

