/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.items;

import blusunrize.immersiveengineering.api.tool.IUpgrade;
import blusunrize.immersiveengineering.api.tool.IUpgradeableTool;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import flaxbeard.immersivepetroleum.common.items.ItemIPInternalStorage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public abstract class ItemIPUpgradableTool
extends ItemIPInternalStorage
implements IUpgradeableTool {
    String upgradeType;

    public ItemIPUpgradableTool(String name, int stackSize, String upgradeType, String ... subNames) {
        super(name, stackSize, subNames);
        this.upgradeType = upgradeType;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !OreDictionary.itemMatches((ItemStack)oldStack, (ItemStack)newStack, (boolean)true);
    }

    public NBTTagCompound getUpgrades(ItemStack stack) {
        return ItemNBTHelper.getTagCompound((ItemStack)stack, (String)"upgrades");
    }

    public void clearUpgrades(ItemStack stack) {
        ItemNBTHelper.remove((ItemStack)stack, (String)"upgrades");
    }

    public void finishUpgradeRecalculation(ItemStack stack) {
    }

    public void recalculateUpgrades(ItemStack stack) {
        this.clearUpgrades(stack);
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (EnumFacing)null);
        NBTTagCompound upgradeTag = this.getUpgradeBase(stack).func_74737_b();
        if (inv != null) {
            for (int i = 0; i < inv.getSlots(); ++i) {
                IUpgrade upg;
                ItemStack u = inv.getStackInSlot(i);
                if (u.func_190926_b() || !(u.func_77973_b() instanceof IUpgrade) || !(upg = (IUpgrade)u.func_77973_b()).getUpgradeTypes(u).contains(this.upgradeType) || !upg.canApplyUpgrades(stack, u)) continue;
                upg.applyUpgrades(stack, u, upgradeTag);
            }
            ItemNBTHelper.setTagCompound((ItemStack)stack, (String)"upgrades", (NBTTagCompound)upgradeTag);
            this.finishUpgradeRecalculation(stack);
        }
    }

    public NBTTagCompound getUpgradeBase(ItemStack stack) {
        return new NBTTagCompound();
    }

    public boolean canTakeFromWorkbench(ItemStack stack) {
        return true;
    }

    public void removeFromWorkbench(EntityPlayer player, ItemStack stack) {
    }

    public abstract boolean canModify(ItemStack var1);

    public abstract Slot[] getWorkbenchSlots(Container var1, ItemStack var2);
}

