/*
 * Decompiled with CFR 0.152.
 */
package net.romvoid95.galactic.core.client.gui.element;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.romvoid95.galactic.core.client.gui.element.GuiElement;
import org.apache.commons.lang3.ArrayUtils;

public class ButtonElement
extends GuiElement {
    protected DynamicTexture BUTTON_ICON_IMAGE;
    protected ResourceLocation BUTTON_ICON;
    protected String displayString;
    private Runnable callback;
    private String errorTooltip = "";

    protected ButtonElement(int x, int y, int height) {
        super(x, y, 100, height);
    }

    public ButtonElement(int xPos, int yPos, int width, String displayString) {
        this(xPos, yPos, width, 20, displayString);
    }

    public ButtonElement(int xPos, int yPos, int width, String displayString, ResourceLocation icon) {
        this(xPos, yPos, width, 20, displayString, icon);
    }

    public ButtonElement(int xPos, int yPos, int width, int height, String displayString) {
        this(xPos, yPos, width, height, displayString, (ResourceLocation)null);
    }

    public ButtonElement(int xPos, int yPos, int width, int height, String displayString, ResourceLocation icon) {
        super(xPos, yPos, width, height);
        this.BUTTON_ICON = icon;
        this.displayString = displayString;
    }

    public ButtonElement(int xPos, int yPos, int width, int height, String displayString, String iconURL) {
        this(xPos, yPos, width, height, displayString);
        try {
            this.BUTTON_ICON_IMAGE = new DynamicTexture(this.loadImageFromURL(iconURL));
        }
        catch (IOException e) {
            this.errorTooltip = e.getCause().getLocalizedMessage();
        }
        this.displayString = displayString;
    }

    public ButtonElement(int xPos, int yPos, int width, int height, String displayString, URL iconURL) {
        this(xPos, yPos, width, height, displayString, iconURL.toString());
    }

    public ButtonElement(int xPos, int yPos, int width, int height, String displayString, BufferedImage icon) {
        super(xPos, yPos, width, height);
        this.BUTTON_ICON_IMAGE = new DynamicTexture(icon);
        this.displayString = displayString;
    }

    public ButtonElement(int xPos, int yPos, String displayString, ResourceLocation icon) {
        this(xPos, yPos, 100, displayString, icon);
    }

    public ButtonElement(int xPos, int yPos, ResourceLocation icon) {
        this(xPos, yPos, 20, "", icon);
    }

    public final void setClickListener(Runnable r) {
        this.callback = r;
    }

    public void onClick() {
        if (this.callback != null) {
            this.callback.run();
        }
    }

    @Override
    public String[] getTooltips() {
        if (this.BUTTON_ICON == null && this.BUTTON_ICON_IMAGE == null && !this.errorTooltip.isEmpty()) {
            return (String[])ArrayUtils.addAll((Object[])super.getTooltips(), (Object[])new String[]{"", "\u00a7cError loading image:", "\u00a7c" + this.errorTooltip});
        }
        return super.getTooltips();
    }

    @Override
    public void draw(int mouseX, int mouseY, float partial) {
        if (this.visible) {
            this.hovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
            int k = this.getHoverState(this.hovered);
            GuiUtils.drawContinuousTexturedBox((ResourceLocation)BUTTON_TEXTURES, (int)this.getX(), (int)this.getY(), (int)0, (int)(46 + k * 20), (int)this.width, (int)this.height, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.field_73735_i);
            int color = 0xE0E0E0;
            if (this.packedFGColour != 0) {
                color = this.packedFGColour;
            } else if (!this.enabled) {
                color = 0xA0A0A0;
            } else if (this.hovered) {
                color = 0xFFFFA0;
            }
            int bx = this.getX();
            int mwidth = this.width;
            if (this.BUTTON_ICON != null && this.BUTTON_ICON_IMAGE == null) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.BUTTON_ICON);
                ButtonElement.func_146110_a((int)(bx + 2), (int)(this.getY() + 2), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                bx += 18;
                mwidth -= 16;
            } else if (this.BUTTON_ICON_IMAGE != null && this.BUTTON_ICON == null) {
                this.mc.func_110434_K().func_110577_a(this.mc.field_71446_o.func_110578_a("icon", this.BUTTON_ICON_IMAGE));
                ButtonElement.func_146110_a((int)(bx + 2), (int)this.getY(), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                bx += 18;
                mwidth -= 16;
            } else if (this.BUTTON_ICON_IMAGE == null && this.BUTTON_ICON == null && !this.errorTooltip.equals("")) {
                this.mc.func_110434_K().func_110577_a(errorIcon);
                ButtonElement.func_146110_a((int)(bx + 2), (int)this.getY(), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                bx += 18;
                mwidth -= 16;
            }
            String buttonText = this.displayString;
            int strWidth = this.mc.field_71466_p.func_78256_a(buttonText);
            int ellipsisWidth = this.mc.field_71466_p.func_78256_a("...");
            if (strWidth > mwidth - 6 && strWidth > ellipsisWidth) {
                buttonText = this.mc.field_71466_p.func_78269_a(buttonText, mwidth - 6 - ellipsisWidth).trim() + "...";
            }
            this.func_73732_a(this.mc.field_71466_p, buttonText, bx + mwidth / 2, this.getY() + (this.height - 8) / 2, color);
        }
    }

    protected int getHoverState(boolean mouseOver) {
        int i = 1;
        if (!this.enabled) {
            i = 0;
        } else if (mouseOver) {
            i = 2;
        }
        return i;
    }

    public final void setText(String text) {
        this.displayString = text;
    }

    @Override
    public void mouseClick(int mouseX, int mouseY, int mouseButton) {
        if (this.mousePressed(this.mc, mouseX, mouseY)) {
            this.playPressSound();
            if (this.enabled) {
                this.onClick();
            }
        }
    }

    public boolean mousePressed(Minecraft mc, int mouseX, int mouseY) {
        return this.visible && mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int state) {
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
    }

    @Override
    public void mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
    }

    public static class DefaultButtonIcons {
        public static final ResourceLocation ADD = new ResourceLocation("eguilib:textures/gui/buttonicons/add.png");
        public static final ResourceLocation DELETE = new ResourceLocation("eguilib:textures/gui/buttonicons/delete.png");
        public static final ResourceLocation PLAY = new ResourceLocation("eguilib:textures/gui/buttonicons/play.png");
        public static final ResourceLocation PAUSE = new ResourceLocation("eguilib:textures/gui/buttonicons/pause.png");
        public static final ResourceLocation STOP = new ResourceLocation("eguilib:textures/gui/buttonicons/stop.png");
        public static final ResourceLocation SAVE = new ResourceLocation("eguilib:textures/gui/buttonicons/save.png");
        public static final ResourceLocation NEW = new ResourceLocation("eguilib:textures/gui/buttonicons/new.png");
        public static final ResourceLocation FILE = new ResourceLocation("eguilib:textures/gui/buttonicons/file.png");
        public static final ResourceLocation FILE_TXT = new ResourceLocation("eguilib:textures/gui/buttonicons/file_txt.png");
        public static final ResourceLocation FILE_NBT = new ResourceLocation("eguilib:textures/gui/buttonicons/file_nbt.png");
        public static final ResourceLocation FILE_BIN = new ResourceLocation("eguilib:textures/gui/buttonicons/file_bin.png");
        public static final ResourceLocation ARROW_RIGHT = new ResourceLocation("eguilib:textures/gui/buttonicons/arrow-right.png");
        public static final ResourceLocation ARROW_LEFT = new ResourceLocation("eguilib:textures/gui/buttonicons/arrow-left.png");
    }
}

