/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.renderer;

import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.AnimationRenderer;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.face.NorthFace;
import net.malisis.doors.tileentity.ForcefieldTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import org.lwjgl.opengl.GL11;

public class ForcefieldRenderer
extends MalisisRenderer<ForcefieldTileEntity> {
    protected static ResourceLocation[] rl;
    protected ForcefieldTileEntity tileEntity;
    protected AxisAlignedBB aabb;
    protected EnumFacing direction;
    protected double scaleX;
    protected double scaleY;
    protected Shape shape;
    protected RenderParameters rp;
    protected AnimationRenderer ar = new AnimationRenderer();

    public ForcefieldRenderer() {
        this.registerFor(ForcefieldTileEntity.class);
    }

    protected void initialize() {
        rl = new ResourceLocation[50];
        for (int i = 0; i < 50; ++i) {
            ForcefieldRenderer.rl[i] = new ResourceLocation(String.format("malisisdoors:textures/blocks/forcefield/forcefield%02d.png", i));
        }
        this.shape = new Shape(new Face[]{new NorthFace()});
        this.rp = new RenderParameters();
        this.rp.interpolateUV.set((Object)false);
        this.rp.useBlockBounds.set((Object)false);
        this.rp.calculateAOColor.set((Object)false);
        this.rp.setBrightness(0xF000F0);
        this.rp.useEnvironmentBrightness.set((Object)false);
        this.rp.calculateBrightness.set((Object)false);
        this.rp.applyTexture.set((Object)false);
        this.rp.alpha.set((Object)50);
    }

    private void setDirection() {
        this.direction = this.aabb.field_72337_e - this.aabb.field_72338_b == 0.0 ? EnumFacing.UP : (this.aabb.field_72336_d - this.aabb.field_72340_a == 0.0 ? EnumFacing.EAST : EnumFacing.NORTH);
    }

    private void setScale() {
        this.scaleX = 1.0;
        this.scaleY = 1.0;
        if (this.direction == EnumFacing.UP) {
            this.scaleX = this.aabb.field_72336_d - this.aabb.field_72340_a;
            this.scaleY = this.aabb.field_72334_f - this.aabb.field_72339_c;
        } else {
            this.scaleY = this.aabb.field_72337_e - this.aabb.field_72338_b;
            if (this.direction == EnumFacing.EAST) {
                this.scaleX = this.aabb.field_72334_f - this.aabb.field_72339_c;
            } else if (this.direction == EnumFacing.NORTH) {
                this.scaleX = this.aabb.field_72336_d - this.aabb.field_72340_a;
            }
        }
    }

    public void render() {
        this.tileEntity = (ForcefieldTileEntity)((MalisisRenderer)this).tileEntity;
        if (this.tileEntity == null || this.tileEntity.isOpened()) {
            return;
        }
        this.aabb = this.tileEntity.getRenderBoundingBox().func_72317_d((double)(-this.pos.func_177958_n()), (double)(-this.pos.func_177956_o()), (double)(-this.pos.func_177952_p()));
        this.setDirection();
        this.setScale();
        this.enableBlending();
        this.shape = new Shape(new Face[]{new NorthFace()});
        if (this.direction == EnumFacing.UP) {
            this.shape.rotate(90.0f, 1.0f, 0.0f, 0.0f);
        } else if (this.direction == EnumFacing.EAST) {
            this.shape.rotate(90.0f, 0.0f, 1.0f, 0.0f);
        }
        this.shape.translate(0.0f, 0.0f, 0.5f);
        this.shape.scale((float)this.scaleX, (float)this.scaleY, 1.0f, this.direction == EnumFacing.EAST ? 0.5f : -0.5f, -0.5f, 0.5f);
        this.setTextureMatrix();
        GL11.glBlendFunc((int)1, (int)1);
        GL11.glDisable((int)2884);
        this.drawShape(this.shape, this.rp);
        this.next();
        GL11.glEnable((int)2884);
        GL11.glMatrixMode((int)5890);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glDisable((int)3042);
    }

    private void setTextureMatrix() {
        long elapsed = this.ar.getElapsedTime() / 50L;
        int n = (int)(elapsed % 50L);
        this.func_147499_a(rl[n]);
        GL11.glMatrixMode((int)5890);
        GL11.glLoadIdentity();
        if (this.direction == EnumFacing.UP && this.aabb.field_72334_f - this.aabb.field_72339_c > this.aabb.field_72336_d - this.aabb.field_72340_a) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glScaled((double)(this.scaleX / 3.0), (double)(this.scaleY / 3.0), (double)1.0);
        GL11.glMatrixMode((int)5888);
    }
}

