/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import mcjty.lib.McJtyLib;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.lib.tileentity.GenericTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;

public class PacketSendGuiData
implements IMessage {
    private int dimId;
    private BlockPos pos;
    private Object[] data;
    private static final Map<Integer, Entry<?>> CLASS_MAP = new HashMap();

    public void fromBytes(ByteBuf buf) {
        this.dimId = buf.readInt();
        this.pos = NetworkTools.readPos(buf);
        int size = buf.readShort();
        this.data = new Object[size];
        for (int i = 0; i < size; ++i) {
            byte type = buf.readByte();
            this.data[i] = ((Entry)CLASS_MAP.get(type)).func.apply(buf);
        }
    }

    private static <T> void acceptCasted(Entry<T> triple, ByteBuf buf, Object o) {
        ((Entry)triple).consumer.accept(Pair.of((Object)buf, triple.cast(o)));
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimId);
        NetworkTools.writePos(buf, this.pos);
        buf.writeShort(this.data.length);
        for (Object o : this.data) {
            boolean ok = false;
            for (Map.Entry<Integer, Entry<?>> entry : CLASS_MAP.entrySet()) {
                Entry<?> triple = entry.getValue();
                if (!triple.match(o)) continue;
                buf.writeByte(entry.getKey().intValue());
                PacketSendGuiData.acceptCasted(triple, buf, o);
                ok = true;
                break;
            }
            if (ok) continue;
            throw new RuntimeException("Unsupported type in getDataForGUI!");
        }
    }

    public PacketSendGuiData() {
    }

    public PacketSendGuiData(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketSendGuiData(World world, BlockPos pos) {
        this.dimId = world.field_73011_w.getDimension();
        this.pos = pos;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof GenericTileEntity) {
            GenericTileEntity genericTileEntity = (GenericTileEntity)te;
            this.data = genericTileEntity.getDataForGUI();
        } else {
            this.data = new Object[0];
        }
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te;
            World world = McJtyLib.proxy.getClientWorld();
            if (world.field_73011_w.getDimension() == this.dimId && (te = world.func_175625_s(this.pos)) instanceof GenericTileEntity) {
                GenericTileEntity tileEntity = (GenericTileEntity)te;
                tileEntity.syncDataForGUI(this.data);
            }
        });
        ctx.setPacketHandled(true);
    }

    static {
        int id = 0;
        CLASS_MAP.put(id++, Entry.of(Integer.class, ByteBuf::readInt, p -> ((ByteBuf)p.getLeft()).writeInt(((Integer)p.getRight()).intValue())));
        CLASS_MAP.put(id++, Entry.of(String.class, NetworkTools::readString, p -> NetworkTools.writeString((ByteBuf)p.getLeft(), (String)p.getRight())));
        CLASS_MAP.put(id++, Entry.of(Float.class, ByteBuf::readFloat, p -> ((ByteBuf)p.getLeft()).writeFloat(((Float)p.getRight()).floatValue())));
        CLASS_MAP.put(id++, Entry.of(Boolean.class, ByteBuf::readBoolean, p -> ((ByteBuf)p.getLeft()).writeBoolean(((Boolean)p.getRight()).booleanValue())));
        CLASS_MAP.put(id++, Entry.of(Byte.class, ByteBuf::readByte, p -> ((ByteBuf)p.getLeft()).writeByte((int)((Byte)p.getRight()).byteValue())));
        CLASS_MAP.put(id++, Entry.of(Long.class, ByteBuf::readLong, p -> ((ByteBuf)p.getLeft()).writeLong(((Long)p.getRight()).longValue())));
        CLASS_MAP.put(id++, Entry.of(BlockPos.class, NetworkTools::readPos, p -> NetworkTools.writePos((ByteBuf)p.getLeft(), (BlockPos)p.getRight())));
    }

    private static class Entry<T> {
        private final Class<T> clazz;
        private final Function<ByteBuf, ? extends T> func;
        private final Consumer<Pair<ByteBuf, ? extends T>> consumer;

        private Entry(Class<T> clazz, Function<ByteBuf, ? extends T> func, Consumer<Pair<ByteBuf, ? extends T>> consumer) {
            this.clazz = clazz;
            this.func = func;
            this.consumer = consumer;
        }

        public static <T> Entry<T> of(Class<T> clazz, Function<ByteBuf, ? extends T> func, Consumer<Pair<ByteBuf, ? extends T>> consumer) {
            return new Entry<T>(clazz, func, consumer);
        }

        public boolean match(Object o) {
            return this.clazz.isInstance(o);
        }

        public T cast(Object o) {
            return this.clazz.cast(o);
        }
    }
}

