/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.interfaces;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.superfactory.CollisionHelper;
import vswe.superfactory.Localization;
import vswe.superfactory.interfaces.ContainerRelay;
import vswe.superfactory.interfaces.GuiBase;
import vswe.superfactory.network.packets.DataBitHelper;
import vswe.superfactory.network.packets.DataWriter;
import vswe.superfactory.network.packets.PacketHandler;
import vswe.superfactory.tiles.TileEntityRelay;
import vswe.superfactory.util.UserPermission;
import vswe.superfactory.util.Utils;

@SideOnly(value=Side.CLIENT)
public class GuiRelay
extends GuiBase {
    private static final int BUTTON_AREA_WIDTH = 97;
    private static final int BUTTON_AREA_X = 121;
    private static final int BUTTON_AREA_Y = 13;
    private static final int BUTTON_HEIGHT = 11;
    private static final int BUTTON_TEXT_Y = 4;
    private static final int BUTTON_WIDTH = 47;
    private static final int BUTTON_X_LEFT = 121;
    private static final int BUTTON_X_MIDDLE = 146;
    private static final int BUTTON_X_RIGHT = 171;
    private static final int BUTTON_Y_BOT = 75;
    private static final int BUTTON_Y_DOWN = 64;
    private static final int BUTTON_Y_FAR_BOT = 90;
    private static final int BUTTON_Y_FURTHER_DOWN = 77;
    private static final int BUTTON_Y_MIDDLE = 60;
    private static final int BUTTON_Y_TOP = 45;
    private static final int INFO_BOX_FULL_TEXT_W = 85;
    private static final int INFO_BOX_FULL_TEXT_X = 5;
    private static final int INFO_BOX_FULL_TEXT_Y = 5;
    private static final int INFO_BOX_INFO_X = 5;
    private static final int INFO_BOX_INFO_Y = 16;
    private static final int INFO_BOX_NAME_X = 5;
    private static final int INFO_BOX_NAME_Y = 5;
    private static final int INFO_BOX_POS_X = 122;
    private static final int INFO_BOX_POS_Y = 109;
    private static final int INFO_MARGIN_INFO_Y = 3;
    private static final int INFO_MARGIN_X = 1;
    private static final int INFO_MARGIN_Y = 2;
    private static final int INFO_SIZE = 7;
    private static final int INFO_TEXT_X = 6;
    private static final int INFO_TEXT_Y = 1;
    private static final int LIST_MENU_HEIGHT = 12;
    private static final int LIST_MENU_WIDTH = 95;
    private static final int LIST_POS_X = 12;
    private static final int LIST_POS_Y = 14;
    private static final int LIST_TEXT_POS_X = 3;
    private static final int LIST_TEXT_POS_Y = 4;
    private static final int NO_ACCESS_TEXT_Y = 30;
    private static final int PAGE_BUTTON_DISTANCE = 40;
    private static final int PAGE_BUTTON_SIZE = 7;
    private static final int PAGE_BUTTON_X_LEFT = 32;
    private static final int PAGE_BUTTON_X_RIGHT = 79;
    private static final int PAGE_BUTTON_Y = 147;
    private static final int PAGE_Y = 149;
    private static final int PERMISSIONS_PER_PAGE = 11;
    private static final ResourceLocation TEXTURE = GuiRelay.registerTexture("relay");
    private List<Button> buttons = new ArrayList<Button>();
    private UserPermission cachedPermission;
    private int currentPage;
    private boolean hasCachedPermission;
    private TileEntityRelay relay;
    private int selectedPermission = -1;

    public GuiRelay(final TileEntityRelay relay, InventoryPlayer player) {
        super(new ContainerRelay(relay, player));
        this.xSize = 229;
        this.ySize = 158;
        this.relay = relay;
        System.out.println(relay + " opened");
        this.buttons.add(new Button(Localization.GIVE_PERMISSION, 121, 64){

            @Override
            public boolean isVisible() {
                return GuiRelay.this.getSelectedPermission() == -1;
            }

            @Override
            public boolean isEnabled() {
                return GuiRelay.this.getUserPermission() == null;
            }

            @Override
            public void onClick() {
                if (relay.getPermissions().size() < TileEntityRelay.PERMISSION_MAX_LENGTH) {
                    relay.getPermissions().add(new UserPermission(GuiRelay.this.getUserId(), GuiRelay.this.getUserName()));
                    GuiRelay.this.addUser();
                }
            }
        });
        this.buttons.add(new Button(Localization.REVOKE_PERMISSION, 171, 64){

            @Override
            public boolean isVisible() {
                return GuiRelay.this.getSelectedPermission() == -1;
            }

            @Override
            public boolean isEnabled() {
                return GuiRelay.this.getUserPermission() != null;
            }

            @Override
            public void onClick() {
                GuiRelay.this.removeUser();
            }
        });
        this.buttons.add(new Button(Localization.ACTIVATE_USER, 121, 45){

            @Override
            public boolean isVisible() {
                return GuiRelay.this.getSelectedPermission() != -1 && GuiRelay.this.isOp(GuiRelay.this.getUserPermission(), true);
            }

            @Override
            public boolean isEnabled() {
                return !relay.getPermissions().get(GuiRelay.this.getSelectedPermission()).isActive();
            }

            @Override
            public void onClick() {
                relay.getPermissions().get(GuiRelay.this.getSelectedPermission()).setActive(true);
                GuiRelay.this.updateUser(GuiRelay.this.getSelectedPermission());
            }
        });
        this.buttons.add(new Button(Localization.DEACTIVATE_USER, 171, 45){

            @Override
            public boolean isVisible() {
                return GuiRelay.this.getSelectedPermission() != -1 && GuiRelay.this.isOp(GuiRelay.this.getUserPermission(), true);
            }

            @Override
            public boolean isEnabled() {
                return relay.getPermissions().get(GuiRelay.this.getSelectedPermission()).isActive();
            }

            @Override
            public void onClick() {
                relay.getPermissions().get(GuiRelay.this.getSelectedPermission()).setActive(false);
                GuiRelay.this.updateUser(GuiRelay.this.getSelectedPermission());
            }
        });
        this.buttons.add(new Button(Localization.DELETE_USER, 146, 75){

            @Override
            public boolean isVisible() {
                return GuiRelay.this.getSelectedPermission() != -1 && GuiRelay.this.isOp(GuiRelay.this.getUserPermission(), true);
            }

            @Override
            public boolean isEnabled() {
                return true;
            }

            @Override
            public void onClick() {
                GuiRelay.this.removeUser(GuiRelay.this.getSelectedPermission());
                GuiRelay.this.selectedPermission = -1;
            }
        });
        this.buttons.add(new Button(Localization.MAKE_EDITOR, 121, 60){

            @Override
            public boolean isVisible() {
                return GuiRelay.this.getSelectedPermission() != -1 && GuiRelay.this.isOwner(GuiRelay.this.getUserPermission(), true) && !GuiRelay.this.isOwner(relay.getPermissions().get(GuiRelay.this.getSelectedPermission()), false);
            }

            @Override
            public boolean isEnabled() {
                return !relay.getPermissions().get(GuiRelay.this.getSelectedPermission()).isOp();
            }

            @Override
            public void onClick() {
                relay.getPermissions().get(GuiRelay.this.getSelectedPermission()).setOp(true);
                GuiRelay.this.updateUser(GuiRelay.this.getSelectedPermission());
            }
        });
        this.buttons.add(new Button(Localization.REMOVE_EDITOR, 171, 60){

            @Override
            public boolean isVisible() {
                return GuiRelay.this.getSelectedPermission() != -1 && GuiRelay.this.isOwner(GuiRelay.this.getUserPermission(), true) && !GuiRelay.this.isOwner(relay.getPermissions().get(GuiRelay.this.getSelectedPermission()), false);
            }

            @Override
            public boolean isEnabled() {
                return relay.getPermissions().get(GuiRelay.this.getSelectedPermission()).isOp();
            }

            @Override
            public void onClick() {
                relay.getPermissions().get(GuiRelay.this.getSelectedPermission()).setOp(false);
                GuiRelay.this.updateUser(GuiRelay.this.getSelectedPermission());
            }
        });
        this.buttons.add(new Button(Localization.SHOW_LIST_TO_ALL, 121, 77){

            @Override
            public boolean isVisible() {
                return GuiRelay.this.getSelectedPermission() == -1 && GuiRelay.this.isOp(GuiRelay.this.getUserPermission(), true);
            }

            @Override
            public boolean isEnabled() {
                return relay.doesListRequireOp();
            }

            @Override
            public void onClick() {
                relay.setListRequireOp(false);
                GuiRelay.this.updateGlobalSettings();
            }
        });
        this.buttons.add(new Button(Localization.SHOW_TO_EDITORS, 171, 77){

            @Override
            public boolean isVisible() {
                return GuiRelay.this.getSelectedPermission() == -1 && GuiRelay.this.isOp(GuiRelay.this.getUserPermission(), true);
            }

            @Override
            public boolean isEnabled() {
                return !relay.doesListRequireOp();
            }

            @Override
            public void onClick() {
                relay.setListRequireOp(true);
                GuiRelay.this.updateGlobalSettings();
            }
        });
        this.buttons.add(new Button(Localization.ENABLE_CREATIVE_MODE, 121, 90){

            @Override
            public boolean isVisible() {
                return GuiRelay.this.getSelectedPermission() == -1 && GuiRelay.this.isOp(GuiRelay.this.getUserPermission(), true) && (Minecraft.func_71410_x().field_71442_b.func_78758_h() || relay.isCreativeMode());
            }

            @Override
            public boolean isEnabled() {
                return !relay.isCreativeMode();
            }

            @Override
            public void onClick() {
                relay.setCreativeMode(true);
                GuiRelay.this.updateGlobalSettings();
            }
        });
        this.buttons.add(new Button(Localization.DISABLE_CREATIVE_MODE, 171, 90){

            @Override
            public boolean isVisible() {
                return GuiRelay.this.getSelectedPermission() == -1 && GuiRelay.this.isOp(GuiRelay.this.getUserPermission(), true) && (Minecraft.func_71410_x().field_71442_b.func_78758_h() || relay.isCreativeMode());
            }

            @Override
            public boolean isEnabled() {
                return relay.isCreativeMode();
            }

            @Override
            public void onClick() {
                relay.setCreativeMode(false);
                GuiRelay.this.updateGlobalSettings();
            }
        });
    }

    @Override
    public ResourceLocation getComponentResource() {
        return TEXTURE;
    }

    private int getSelectedPermission() {
        if (this.selectedPermission < 0 || this.selectedPermission >= this.relay.getPermissions().size() || this.relay.doesListRequireOp() && !this.isOp(this.getUserPermission(), true)) {
            this.selectedPermission = -1;
            return -1;
        }
        return this.selectedPermission;
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int mX, int mY) {
        UserPermission info;
        int y;
        int i;
        UserPermission selected;
        this.hasCachedPermission = false;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiRelay.bindTexture(TEXTURE);
        this.drawTexture(0, 0, 0, 0, this.xSize, this.ySize);
        mX -= this.guiLeft;
        mY -= this.guiTop;
        UserPermission player = this.getUserPermission();
        UserPermission userPermission = selected = this.getSelectedPermission() == -1 ? null : this.relay.getPermissions().get(this.getSelectedPermission());
        if (!this.relay.doesListRequireOp() || this.isOp(player, true)) {
            int start;
            for (i = start = this.getStartId(); i <= this.getEndId(); ++i) {
                UserPermission permission = this.relay.getPermissions().get(i);
                int x = 12;
                int y2 = 14 + (i - start) * 12;
                int srcXMenu = this.getSelectedPermission() == i ? 1 : 0;
                int srcYMenu = CollisionHelper.inBounds(x, y2, 95, 12, mX, mY) ? 1 : 0;
                this.drawTexture(x, y2, srcXMenu * 95, this.ySize + srcYMenu * 12, 95, 12);
                for (int j = 0; j < 2; ++j) {
                    this.renderInfoBox(j, permission, x + 95 - (1 + j) * 8, y2 + 2);
                }
                this.drawString(permission.getUserName(), x + 3, y2 + 4, 0.7f, 0xEEEEEE);
            }
            if (this.getPageCount() > 1) {
                this.drawCenteredString(Localization.PAGE.toString() + " " + (this.currentPage + 1) + " " + Localization.OF.toString() + " " + this.getPageCount(), 12, 149, 0.6f, 95, 0x404040);
                for (i = 0; i < 2; ++i) {
                    int x = i == 0 ? 32 : 79;
                    y = 147;
                    int srcXButton = i;
                    int srcYButton = CollisionHelper.inBounds(x, y, 7, 7, mX, mY) ? 1 : 0;
                    this.drawTexture(x, y, srcXButton * 7, this.ySize + 24 + 7 + 33 + srcYButton * 7, 7, 7);
                }
            }
        } else {
            this.drawCenteredString(Localization.NO_ACCESS.toString(), 12, 44, 1.0f, 95, 0x804040);
        }
        UserPermission userPermission2 = info = this.relay.doesListRequireOp() && !this.isOp(player, true) ? player : selected;
        if (info != null) {
            this.drawString(info.getUserName(), 127, 114, 0.7f, 0x404040);
            for (i = 0; i < 2; ++i) {
                int x = 127;
                y = 125 + i * 10;
                this.renderInfoBox(i, info, x, y);
                this.drawInfoBoxString(i, info, x + 7 + 6, y + 1);
            }
        } else {
            String str = this.isOp(player, true) ? Localization.EDITOR_DESCRIPTION_SHORT.toString() : Localization.USER_DESCRIPTION_SHORT.toString();
            this.drawSplitString(str, 127, 114, 85, 0.7f, 0x404040);
        }
        for (Button button : this.buttons) {
            if (!button.isVisible()) continue;
            int textureId = button.isEnabled() ? (CollisionHelper.inBounds(button.x, button.y, 47, 11, mX, mY) ? 2 : 1) : 0;
            this.drawTexture(button.x, button.y, 0, this.ySize + 24 + 7 + 11 * textureId, 47, 11);
            this.drawCenteredString(button.name.toString(), button.x, button.y + 4, 0.4f, 47, button.isEnabled() ? 0x404040 : 0x808080);
        }
        String message = null;
        if (this.getSelectedPermission() == -1) {
            message = Localization.USER_DESCRIPTION_LONG.toString();
        } else if (this.isOp(this.getUserPermission(), true)) {
            message = Localization.EDITOR_DESCRIPTION_LONG.toString();
        }
        if (message != null) {
            this.drawSplitString(message, 121, 13, 97, 0.6f, 0x404040);
        }
    }

    @Override
    protected void func_73864_a(int mX, int mY, int b) throws IOException {
        mX = this.scaleX(mX);
        mY = this.scaleY(mY);
        super.func_73864_a(mX, mY, b);
        mX -= this.guiLeft;
        mY -= this.guiTop;
        UserPermission player = this.getUserPermission();
        if (!this.relay.doesListRequireOp() || this.isOp(player, true)) {
            int start;
            int i;
            for (i = start = this.getStartId(); i <= this.getEndId(); ++i) {
                UserPermission permission = this.relay.getPermissions().get(i);
                int x = 12;
                int y = 14 + (i - start) * 12;
                if (!CollisionHelper.inBounds(x, y, 95, 12, mX, mY)) continue;
                if (this.getSelectedPermission() == i) {
                    this.selectedPermission = -1;
                    break;
                }
                this.selectedPermission = i;
                break;
            }
            if (this.getPageCount() > 1) {
                for (i = -1; i <= 1; i += 2) {
                    int y;
                    int x = i == -1 ? 32 : 79;
                    if (!CollisionHelper.inBounds(x, y = 147, 7, 7, mX, mY)) continue;
                    this.currentPage += i;
                    if (this.currentPage < 0) {
                        this.currentPage = this.getPageCount() - 1;
                        break;
                    }
                    if (this.currentPage != this.getPageCount()) break;
                    this.currentPage = 0;
                    break;
                }
            }
        }
        for (Button button : this.buttons) {
            if (!button.isVisible() || !button.isEnabled() || !CollisionHelper.inBounds(button.x, button.y, 47, 11, mX, mY)) continue;
            button.onClick();
            break;
        }
    }

    private int getStartId() {
        int maxPageId = this.getPageCount();
        if (this.currentPage >= maxPageId) {
            this.currentPage = maxPageId - 1;
        }
        return this.currentPage * 11;
    }

    private int getPageCount() {
        return (this.relay.getPermissions().size() - 1) / 11 + 1;
    }

    private int getEndId() {
        return Math.min(this.getStartId() + 11, this.relay.getPermissions().size()) - 1;
    }

    private void renderInfoBox(int id, UserPermission permission, int x, int y) {
        int textureId = id == 0 ? (this.isOwner(permission, false) ? 5 : (this.isOp(permission, false) ? 4 : 3)) : (permission.isActive() ? (this.relay.isCreativeMode() ? 2 : 1) : 0);
        this.drawTexture(x, y, textureId * 7, this.ySize + 24, 7, 7);
    }

    private void drawInfoBoxString(int id, UserPermission permission, int x, int y) {
        String str = id == 0 ? (this.isOwner(permission, false) ? Localization.PERMISSION_OWNER.toString() : (this.isOp(permission, false) ? Localization.PERMISSION_EDITOR.toString() : Localization.PERMISSION_USER.toString())) : (this.relay.isCreativeMode() ? (permission.isActive() ? Localization.PERMISSION_RESTRICTED.toString() : Localization.PERMISSION_CREATIVE.toString()) : (permission.isActive() ? Localization.PERMISSION_INVENTORY.toString() : Localization.PERMISSION_DENIED.toString()));
        this.drawString(str, x, y, 0.7f, 0x404040);
    }

    private boolean isOwner(UserPermission permission, boolean viewer) {
        return permission != null && permission.getUserId().equals(this.relay.getOwner()) || viewer && this.getUserId().equals(this.relay.getOwner());
    }

    private boolean isOp(UserPermission permission, boolean viewer) {
        return this.isOwner(permission, viewer) || permission != null && permission.isOp();
    }

    private UUID getUserId() {
        return Minecraft.func_71410_x().field_71439_g.func_110124_au();
    }

    private String getUserName() {
        return Utils.stripControlCodes(Minecraft.func_71410_x().field_71439_g.getDisplayNameString());
    }

    private UserPermission getUserPermission() {
        if (this.hasCachedPermission) {
            return this.cachedPermission;
        }
        this.hasCachedPermission = true;
        this.cachedPermission = null;
        for (UserPermission permission : this.relay.getPermissions()) {
            if (!permission.getUserId().equals(this.getUserId())) continue;
            this.cachedPermission = permission;
            break;
        }
        return this.cachedPermission;
    }

    private void removeUser(int id) {
        DataWriter dw = PacketHandler.getWriterForServerPacket();
        dw.writeBoolean(true);
        dw.writeBoolean(false);
        dw.writeData(id, DataBitHelper.PERMISSION_ID);
        dw.writeBoolean(true);
        PacketHandler.sendDataToServer(dw);
    }

    private void removeUser() {
        for (int i = 0; i < this.relay.getPermissions().size(); ++i) {
            if (!this.relay.getPermissions().get(i).getUserId().equals(this.getUserId())) continue;
            this.removeUser(i);
            break;
        }
    }

    private void updateGlobalSettings() {
        DataWriter dw = PacketHandler.getWriterForServerPacket();
        dw.writeBoolean(false);
        dw.writeBoolean(this.relay.isCreativeMode());
        dw.writeBoolean(this.relay.doesListRequireOp());
        PacketHandler.sendDataToServer(dw);
    }

    private void addUser() {
        DataWriter dw = PacketHandler.getWriterForServerPacket();
        dw.writeBoolean(true);
        dw.writeBoolean(true);
        dw.writeString(this.getUserId().toString(), DataBitHelper.UUID_LENGTH);
        dw.writeString(this.getUserName(), DataBitHelper.NAME_LENGTH);
        PacketHandler.sendDataToServer(dw);
    }

    private void updateUser(int id) {
        UserPermission permission = this.relay.getPermissions().get(id);
        DataWriter dw = PacketHandler.getWriterForServerPacket();
        dw.writeBoolean(true);
        dw.writeBoolean(false);
        dw.writeData(id, DataBitHelper.PERMISSION_ID);
        dw.writeBoolean(false);
        dw.writeBoolean(permission.isActive());
        dw.writeBoolean(permission.isOp());
        PacketHandler.sendDataToServer(dw);
    }

    private abstract class Button {
        private Localization name;
        private int x;
        private int y;

        protected Button(Localization name, int x, int y) {
            this.name = name;
            this.x = x;
            this.y = y;
        }

        public abstract boolean isVisible();

        public abstract boolean isEnabled();

        public abstract void onClick();
    }
}

