/*
 * Decompiled with CFR 0.152.
 */
package nihiltres.engineersdoors.common.item;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraftforge.registries.IForgeRegistryEntry;
import nihiltres.engineersdoors.EngineersDoors;

public interface IOre {
    public static final Map<String, Set<String>> oreNameMap = new HashMap<String, Set<String>>();

    public static void externallyMap(Item item, String oreNameIn) {
        String key = IOre.getMapName(item);
        if (!oreNameMap.containsKey(key)) {
            TreeSet<String> newSet = new TreeSet<String>();
            newSet.add(oreNameIn);
            oreNameMap.put(key, newSet);
        } else {
            oreNameMap.get(key).add(oreNameIn);
        }
    }

    public static void externallyMap(Item item, Set<String> oreNamesIn) {
        String key = IOre.getMapName(item);
        if (!oreNameMap.containsKey(key)) {
            TreeSet<String> newSet = new TreeSet<String>();
            newSet.addAll(oreNamesIn);
            oreNameMap.put(key, newSet);
        } else {
            oreNameMap.get(key).addAll(oreNamesIn);
        }
    }

    public static String getMapName(IForgeRegistryEntry<?> item) {
        return item.getRegistryName().toString();
    }

    public static void demap(IOre ore) {
        if (oreNameMap.remove(ore.getMapName()) == null) {
            EngineersDoors.log(String.format("Nothing removed while demapping IOre \"%s\"", ore.getMapName()));
        }
    }

    public static void demap(IForgeRegistryEntry<?> item) {
        oreNameMap.remove(IOre.getMapName(item));
    }

    default public String getMapName() {
        if (this instanceof IForgeRegistryEntry) {
            return IOre.getMapName((IForgeRegistryEntry)this);
        }
        throw new UnsupportedOperationException("Objects not implementing IForgeRegistryEntry must override getMappedName");
    }

    default public Set<String> getOreNames() {
        String key = this.getMapName();
        if (key == null) {
            throw new IllegalStateException("Null string from IOre.getMappedName");
        }
        if (oreNameMap.containsKey(key)) {
            return oreNameMap.get(key);
        }
        return new TreeSet<String>();
    }

    default public IOre addOreName(@Nonnull String oreNameIn) {
        String key = this.getMapName();
        if (!oreNameMap.containsKey(key)) {
            TreeSet<String> newSet = new TreeSet<String>();
            newSet.add(oreNameIn);
            oreNameMap.put(key, newSet);
        } else {
            oreNameMap.get(key).add(oreNameIn);
        }
        return this;
    }

    default public IOre addOreNames(@Nonnull Collection<String> oreNamesIn) {
        String key = this.getMapName();
        if (!oreNameMap.containsKey(key)) {
            TreeSet<String> newSet = new TreeSet<String>();
            newSet.addAll(oreNamesIn);
            oreNameMap.put(key, newSet);
        } else {
            oreNameMap.get(key).addAll(oreNamesIn);
        }
        return this;
    }

    default public IOre addOreNames(String ... oreNamesIn) {
        return this.addOreNames(Arrays.asList(oreNamesIn));
    }

    public static void wipeMap() {
        oreNameMap.clear();
    }
}

