/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual;

import WayofTime.bloodmagic.demonAura.WorldDemonWillHandler;
import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumReaderBoundaries;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRenderer;
import WayofTime.bloodmagic.soul.DemonWillHolder;
import WayofTime.bloodmagic.soul.EnumDemonWillType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import org.apache.commons.lang3.builder.ToStringBuilder;

public abstract class Ritual {
    protected final Map<String, AreaDescriptor> modableRangeMap = new HashMap<String, AreaDescriptor>();
    protected final Map<String, Integer> volumeRangeMap = new HashMap<String, Integer>();
    protected final Map<String, Integer> horizontalRangeMap = new HashMap<String, Integer>();
    protected final Map<String, Integer> verticalRangeMap = new HashMap<String, Integer>();
    private final String name;
    private final int crystalLevel;
    private final int activationCost;
    private final RitualRenderer renderer;
    private final String unlocalizedName;

    public Ritual(String name, int crystalLevel, int activationCost, RitualRenderer renderer, String unlocalizedName) {
        this.name = name;
        this.crystalLevel = crystalLevel;
        this.activationCost = activationCost;
        this.renderer = renderer;
        this.unlocalizedName = unlocalizedName;
    }

    public Ritual(String name, int crystalLevel, int activationCost, String unlocalizedName) {
        this(name, crystalLevel, activationCost, null, unlocalizedName);
    }

    public void readFromNBT(NBTTagCompound tag) {
        NBTTagList tags = tag.func_150295_c("areas", 10);
        if (tags.func_82582_d()) {
            return;
        }
        for (int i = 0; i < tags.func_74745_c(); ++i) {
            NBTTagCompound newTag = tags.func_150305_b(i);
            String rangeKey = newTag.func_74779_i("key");
            NBTTagCompound storedTag = newTag.func_74775_l("area");
            AreaDescriptor desc = this.getBlockRange(rangeKey);
            if (desc == null) continue;
            desc.readFromNBT(storedTag);
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList tags = new NBTTagList();
        for (Map.Entry<String, AreaDescriptor> entry : this.modableRangeMap.entrySet()) {
            NBTTagCompound newTag = new NBTTagCompound();
            newTag.func_74778_a("key", entry.getKey());
            NBTTagCompound storedTag = new NBTTagCompound();
            entry.getValue().writeToNBT(storedTag);
            newTag.func_74782_a("area", (NBTBase)storedTag);
            tags.func_74742_a((NBTBase)newTag);
        }
        tag.func_74782_a("areas", (NBTBase)tags);
    }

    public boolean activateRitual(IMasterRitualStone masterRitualStone, EntityPlayer player, UUID owner) {
        return true;
    }

    public abstract void performRitual(IMasterRitualStone var1);

    public void stopRitual(IMasterRitualStone masterRitualStone, BreakType breakType) {
    }

    public abstract int getRefreshCost();

    public int getRefreshTime() {
        return 20;
    }

    public void addBlockRange(String range, AreaDescriptor defaultRange) {
        this.modableRangeMap.put(range, defaultRange);
    }

    public AreaDescriptor getBlockRange(String range) {
        if (this.modableRangeMap.containsKey(range)) {
            return this.modableRangeMap.get(range);
        }
        return null;
    }

    public List<String> getListOfRanges() {
        return new ArrayList<String>(this.modableRangeMap.keySet());
    }

    public String getNextBlockRange(String range) {
        List<String> rangeList = this.getListOfRanges();
        if (rangeList.isEmpty()) {
            return "";
        }
        if (!rangeList.contains(range)) {
            return rangeList.get(0);
        }
        boolean hasMatch = false;
        for (String rangeCheck : rangeList) {
            if (hasMatch) {
                return rangeCheck;
            }
            if (!rangeCheck.equals(range)) continue;
            hasMatch = true;
        }
        return rangeList.get(0);
    }

    public EnumReaderBoundaries canBlockRangeBeModified(String range, AreaDescriptor descriptor, IMasterRitualStone master, BlockPos offset1, BlockPos offset2, DemonWillHolder holder) {
        List<EnumDemonWillType> willConfig = master.getActiveWillConfig();
        int maxVolume = this.getMaxVolumeForRange(range, willConfig, holder);
        int maxVertical = this.getMaxVerticalRadiusForRange(range, willConfig, holder);
        int maxHorizontal = this.getMaxHorizontalRadiusForRange(range, willConfig, holder);
        return maxVolume <= 0 || descriptor.getVolumeForOffsets(offset1, offset2) <= maxVolume ? (descriptor.isWithinRange(offset1, offset2, maxVertical, maxHorizontal) ? EnumReaderBoundaries.SUCCESS : EnumReaderBoundaries.NOT_WITHIN_BOUNDARIES) : EnumReaderBoundaries.VOLUME_TOO_LARGE;
    }

    protected void setMaximumVolumeAndDistanceOfRange(String range, int volume, int horizontalRadius, int verticalRadius) {
        this.volumeRangeMap.put(range, volume);
        this.horizontalRangeMap.put(range, horizontalRadius);
        this.verticalRangeMap.put(range, verticalRadius);
    }

    protected boolean checkDescriptorIsWithinRange(AreaDescriptor descriptor, int maxVolume, int maxHorizontal, int maxVertical) {
        return descriptor.getVolume() <= maxVolume && descriptor.isWithinRange(maxVertical, maxHorizontal);
    }

    public int getMaxVolumeForRange(String range, List<EnumDemonWillType> activeTypes, DemonWillHolder holder) {
        return this.volumeRangeMap.get(range);
    }

    public int getMaxVerticalRadiusForRange(String range, List<EnumDemonWillType> activeTypes, DemonWillHolder holder) {
        return this.verticalRangeMap.get(range);
    }

    public int getMaxHorizontalRadiusForRange(String range, List<EnumDemonWillType> activeTypes, DemonWillHolder holder) {
        return this.horizontalRangeMap.get(range);
    }

    public ITextComponent getErrorForBlockRangeOnFail(EntityPlayer player, String range, IMasterRitualStone master, BlockPos offset1, BlockPos offset2) {
        AreaDescriptor descriptor = this.getBlockRange(range);
        if (descriptor == null) {
            return new TextComponentTranslation("ritual.bloodmagic.blockRange.tooBig", new Object[]{"?"});
        }
        List<EnumDemonWillType> willConfig = master.getActiveWillConfig();
        DemonWillHolder holder = WorldDemonWillHandler.getWillHolder(master.getWorldObj(), master.getBlockPos());
        int maxVolume = this.getMaxVolumeForRange(range, willConfig, holder);
        int maxVertical = this.getMaxVerticalRadiusForRange(range, willConfig, holder);
        int maxHorizontal = this.getMaxHorizontalRadiusForRange(range, willConfig, holder);
        if (maxVolume > 0 && descriptor.getVolumeForOffsets(offset1, offset2) > maxVolume) {
            return new TextComponentTranslation("ritual.bloodmagic.blockRange.tooBig", new Object[]{maxVolume});
        }
        return new TextComponentTranslation("ritual.bloodmagic.blockRange.tooFar", new Object[]{maxVertical, maxHorizontal});
    }

    public ITextComponent[] provideInformationOfRitualToPlayer(EntityPlayer player) {
        return new ITextComponent[]{new TextComponentTranslation(this.getTranslationKey() + ".info", new Object[0])};
    }

    public ITextComponent provideInformationOfRangeToPlayer(EntityPlayer player, String range) {
        if (this.getListOfRanges().contains(range)) {
            return new TextComponentTranslation(this.getTranslationKey() + "." + range + ".info", new Object[0]);
        }
        return new TextComponentTranslation("ritual.bloodmagic.blockRange.noRange", new Object[0]);
    }

    public abstract void gatherComponents(Consumer<RitualComponent> var1);

    protected final void addRune(Consumer<RitualComponent> components, int offset1, int y, int offset2, EnumRuneType rune) {
        components.accept(new RitualComponent(new BlockPos(offset1, y, offset2), rune));
    }

    protected final void addOffsetRunes(Consumer<RitualComponent> components, int offset1, int offset2, int y, EnumRuneType rune) {
        this.addRune(components, offset1, y, offset2, rune);
        this.addRune(components, offset2, y, offset1, rune);
        this.addRune(components, offset1, y, -offset2, rune);
        this.addRune(components, -offset2, y, offset1, rune);
        this.addRune(components, -offset1, y, offset2, rune);
        this.addRune(components, offset2, y, -offset1, rune);
        this.addRune(components, -offset1, y, -offset2, rune);
        this.addRune(components, -offset2, y, -offset1, rune);
    }

    protected final void addCornerRunes(Consumer<RitualComponent> components, int offset, int y, EnumRuneType rune) {
        this.addRune(components, offset, y, offset, rune);
        this.addRune(components, offset, y, -offset, rune);
        this.addRune(components, -offset, y, -offset, rune);
        this.addRune(components, -offset, y, offset, rune);
    }

    protected final void addParallelRunes(Consumer<RitualComponent> components, int offset, int y, EnumRuneType rune) {
        this.addRune(components, offset, y, 0, rune);
        this.addRune(components, -offset, y, 0, rune);
        this.addRune(components, 0, y, -offset, rune);
        this.addRune(components, 0, y, offset, rune);
    }

    public double getWillRespectingConfig(World world, BlockPos pos, EnumDemonWillType type, List<EnumDemonWillType> willConfig) {
        return willConfig.contains(type) ? WorldDemonWillHandler.getCurrentWill(world, pos, type) : 0.0;
    }

    public abstract Ritual getNewCopy();

    public String getName() {
        return this.name;
    }

    public int getCrystalLevel() {
        return this.crystalLevel;
    }

    public int getActivationCost() {
        return this.activationCost;
    }

    public RitualRenderer getRenderer() {
        return this.renderer;
    }

    public String getTranslationKey() {
        return this.unlocalizedName;
    }

    public Map<String, AreaDescriptor> getModableRangeMap() {
        return this.modableRangeMap;
    }

    public Map<String, Integer> getVolumeRangeMap() {
        return this.volumeRangeMap;
    }

    public Map<String, Integer> getHorizontalRangeMap() {
        return this.horizontalRangeMap;
    }

    public Map<String, Integer> getVerticalRangeMap() {
        return this.verticalRangeMap;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("crystalLevel", this.crystalLevel).append("activationCost", this.activationCost).append("renderer", (Object)this.renderer).append("unlocalizedName", (Object)this.unlocalizedName).append("modableRangeMap", this.modableRangeMap).append("volumeRangeMap", this.volumeRangeMap).append("horizontalRangeMap", this.horizontalRangeMap).append("verticalRangeMap", this.verticalRangeMap).append("refreshTime", this.getRefreshTime()).append("listOfRanges", this.getListOfRanges()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Ritual)) {
            return false;
        }
        Ritual ritual = (Ritual)o;
        if (this.crystalLevel != ritual.crystalLevel) {
            return false;
        }
        if (this.activationCost != ritual.activationCost) {
            return false;
        }
        if (this.name != null ? !this.name.equals(ritual.name) : ritual.name != null) {
            return false;
        }
        return this.unlocalizedName != null ? this.unlocalizedName.equals(ritual.unlocalizedName) : ritual.unlocalizedName == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.crystalLevel;
        result = 31 * result + this.activationCost;
        result = 31 * result + (this.unlocalizedName != null ? this.unlocalizedName.hashCode() : 0);
        return result;
    }

    public static enum BreakType {
        REDSTONE,
        BREAK_MRS,
        BREAK_STONE,
        ACTIVATE,
        DEACTIVATE,
        EXPLOSION;

    }
}

