/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.entity;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.ARBShaderObjects;
import vazkii.botania.api.internal.ShaderCallback;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.common.entity.EntityDoppleganger;

public class RenderDoppleganger
extends RenderBiped<EntityDoppleganger> {
    public static final float DEFAULT_GRAIN_INTENSITY = 0.05f;
    public static final float DEFAULT_DISFIGURATION = 0.025f;
    public static float grainIntensity = 0.05f;
    public static float disfiguration = 0.025f;
    public static final ShaderCallback callback = shader -> {
        int disfigurationUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"disfiguration");
        ARBShaderObjects.glUniform1fARB((int)disfigurationUniform, (float)disfiguration);
        int grainIntensityUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"grainIntensity");
        ARBShaderObjects.glUniform1fARB((int)grainIntensityUniform, (float)grainIntensity);
    };
    public static final ShaderCallback defaultCallback = shader -> {
        int disfigurationUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"disfiguration");
        ARBShaderObjects.glUniform1fARB((int)disfigurationUniform, (float)0.025f);
        int grainIntensityUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"grainIntensity");
        ARBShaderObjects.glUniform1fARB((int)grainIntensityUniform, (float)0.05f);
    };

    public RenderDoppleganger(RenderManager renderManager) {
        super(renderManager, (ModelBiped)new ModelPlayer(0.0f, false), 0.0f);
    }

    public void doRender(@Nonnull EntityDoppleganger dopple, double par2, double par4, double par6, float par8, float par9) {
        int invulTime = dopple.getInvulTime();
        if (invulTime > 0) {
            grainIntensity = invulTime > 20 ? 1.0f : (float)invulTime * 0.05f;
            disfiguration = grainIntensity * 0.3f;
        } else {
            disfiguration = (0.025f + (float)dopple.field_70737_aN * 0.0425f) / 2.0f;
            grainIntensity = 0.05f + (float)dopple.field_70737_aN * 0.085f;
        }
        ShaderHelper.useShader(ShaderHelper.doppleganger, callback);
        super.func_76986_a((EntityLiving)dopple, par2, par4, par6, par8, par9);
        ShaderHelper.releaseShader();
    }

    @Nonnull
    protected ResourceLocation getEntityTexture(@Nonnull EntityDoppleganger entity) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!(mc.func_175606_aa() instanceof AbstractClientPlayer)) {
            return DefaultPlayerSkin.func_177335_a();
        }
        return ((AbstractClientPlayer)mc.func_175606_aa()).func_110306_p();
    }
}

