/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.util.guicomponent;

import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.player.PlayerHandler;
import ic2.core.util.math.Box2D;
import ic2.core.util.math.Vec2i;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import trinsdar.ic2c_extras.tileentity.TileEntityFermenter;

public class GuiComponentFermenterProgress
extends GuiComponent {
    TileEntityFermenter block;
    Vec2i texPos;
    boolean fertilizer;

    public GuiComponentFermenterProgress(TileEntityFermenter tile, Box2D box, Vec2i pos, boolean fertilizer) {
        super(box);
        this.block = tile;
        this.texPos = pos;
        this.fertilizer = fertilizer;
    }

    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.BackgroundDraw, GuiComponent.ActionRequest.ToolTip);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiIC2 gui, int mouseX, int mouseY, float particalTicks) {
        int maxProgress;
        float progress = this.fertilizer ? (float)this.block.getFertProgress() : (float)this.block.getBioProgress();
        int n = maxProgress = this.fertilizer ? this.block.getMaxFertProgres() : this.block.getMaxBioProgress();
        if (progress > 0.0f) {
            Box2D box;
            int maxX;
            int lvl;
            int x = gui.getXOffset();
            int y = gui.getYOffset();
            float per = progress / (float)maxProgress;
            if (per > 1.0f) {
                per = 1.0f;
            }
            if ((lvl = (int)(per * (float)(maxX = (box = this.getPosition()).getLenght()))) <= 0) {
                return;
            }
            gui.func_73729_b(x + box.getX(), y + box.getY(), this.texPos.getX(), this.texPos.getY(), lvl, box.getHeight());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onToolTipCollecting(GuiIC2 gui, int mouseX, int mouseY, List<String> tooltips) {
        if (this.isMouseOver(mouseX, mouseY) && PlayerHandler.getClientPlayerHandler().hasEUReader()) {
            float progress = this.fertilizer ? (float)this.block.getFertProgress() : (float)this.block.getBioProgress();
            int maxProgress = this.fertilizer ? this.block.getMaxFertProgres() : this.block.getMaxBioProgress();
            tooltips.add(Ic2InfoLang.machineProgress.getLocalizedFormatted(new Object[]{Float.valueOf(progress), maxProgress}));
        }
    }
}

