/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util.misc.exp;

import ic2.api.classic.recipe.crafting.RecipeInputFluid;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.IRecipeInputFactory;
import ic2.core.item.recipe.entry.RecipeInputArray;
import ic2.core.item.recipe.entry.RecipeInputCombined;
import ic2.core.item.recipe.entry.RecipeInputItemStack;
import ic2.core.item.recipe.entry.RecipeInputOreDict;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fluids.Fluid;

public class RecipeInputFactory
implements IRecipeInputFactory {
    @Override
    public IRecipeInput forStack(ItemStack stack) {
        return this.forStack(stack, stack.func_190916_E());
    }

    @Override
    public IRecipeInput forStack(ItemStack stack, int amount) {
        return new RecipeInputItemStack(stack, amount);
    }

    @Override
    public IRecipeInput forOreDict(String name) {
        return this.forOreDict(name, 1);
    }

    @Override
    public IRecipeInput forOreDict(String name, int amount) {
        return new RecipeInputOreDict(name, amount);
    }

    @Override
    public IRecipeInput forOreDict(String name, int amount, int metaOverride) {
        return new RecipeInputOreDict(name, amount, metaOverride);
    }

    @Override
    public IRecipeInput forFluidContainer(Fluid fluid) {
        return new RecipeInputFluid(fluid);
    }

    @Override
    public IRecipeInput forFluidContainer(Fluid fluid, int amount) {
        return new RecipeInputFluid(fluid, amount);
    }

    @Override
    public IRecipeInput forAny(IRecipeInput ... options) {
        return new RecipeInputCombined(1, options);
    }

    @Override
    public IRecipeInput forAny(Iterable<IRecipeInput> options) {
        final ArrayList<IRecipeInput> inputs = new ArrayList<IRecipeInput>();
        options.forEach(new Consumer<IRecipeInput>(){

            @Override
            public void accept(IRecipeInput t) {
                inputs.add(t);
            }
        });
        return new RecipeInputCombined(inputs);
    }

    @Override
    public IRecipeInput forExactStack(ItemStack stack) {
        return new RecipeInputItemStack(stack);
    }

    @Override
    public IRecipeInput forExactStack(ItemStack stack, int amount) {
        return new RecipeInputItemStack(stack, amount);
    }

    @Override
    public IRecipeInput forIngredient(Ingredient ingredient) {
        return new RecipeInputArray(1, ingredient.func_193365_a());
    }

    @Override
    public Ingredient getIngredient(IRecipeInput input) {
        return Ingredient.func_193369_a((ItemStack[])input.getInputs().toArray(new ItemStack[0]));
    }
}

