/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.manager;

import ic2.api.classic.event.EnergyUsedEvent;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.core.IC2;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.util.helpers.ToolHelper;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.plugins.IBaublesPlugin;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ElectricItemManager
implements IElectricItemManager {
    @Override
    public double charge(ItemStack itemStack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        IElectricItem item = (IElectricItem)itemStack.func_77973_b();
        assert (item.getMaxCharge(itemStack) > 0.0);
        if (amount < 0.0 || itemStack.func_190916_E() > 1 || item.getTier(itemStack) > tier) {
            return 0.0;
        }
        if (!ignoreTransferLimit && amount > item.getTransferLimit(itemStack)) {
            amount = item.getTransferLimit(itemStack);
        }
        NBTTagCompound tNBT = StackUtil.getOrCreateNbtData(itemStack);
        int tNewCharge = tNBT.func_74762_e("charge");
        if (amount > item.getMaxCharge(itemStack) - (double)tNewCharge) {
            amount = item.getMaxCharge(itemStack) - (double)tNewCharge;
        }
        if (!simulate) {
            if ((tNewCharge = (int)((double)tNewCharge + amount)) > 0) {
                tNBT.func_74768_a("charge", tNewCharge);
            } else {
                tNBT.func_82580_o("charge");
                if (tNBT.func_82582_d()) {
                    itemStack.func_77982_d(null);
                }
            }
            if (itemStack.func_77973_b() instanceof IElectricItem) {
                ToolHelper.setDamage(itemStack, this.calculateDamage(itemStack, tNewCharge));
            } else {
                ToolHelper.setDamage(itemStack, 0);
            }
        }
        return amount;
    }

    @Override
    public double discharge(ItemStack itemStack, double amount, int tier, boolean ignoreTransferLimit, boolean externalUse, boolean simulate) {
        NBTTagCompound tNBT;
        int tNewCharge;
        IElectricItem item = (IElectricItem)itemStack.func_77973_b();
        assert (item.getMaxCharge(itemStack) > 0.0);
        if (!itemStack.func_77942_o()) {
            return 0.0;
        }
        if (amount < 0.0 || itemStack.func_190916_E() > 1 || item.getTier(itemStack) > tier) {
            return 0.0;
        }
        if (externalUse && !item.canProvideEnergy(itemStack)) {
            return 0.0;
        }
        if (!ignoreTransferLimit && amount > item.getTransferLimit(itemStack)) {
            amount = item.getTransferLimit(itemStack);
        }
        if (amount > (double)(tNewCharge = (tNBT = StackUtil.getOrCreateNbtData(itemStack)).func_74762_e("charge"))) {
            amount = tNewCharge;
        }
        if (!simulate) {
            if ((tNewCharge = (int)((double)tNewCharge - amount)) > 0) {
                tNBT.func_74768_a("charge", tNewCharge);
            } else {
                tNBT.func_82580_o("charge");
                if (tNBT.func_82582_d()) {
                    itemStack.func_77982_d(null);
                }
            }
            if (itemStack.func_77973_b() instanceof IElectricItem) {
                ToolHelper.setDamage(itemStack, this.calculateDamage(itemStack, tNewCharge));
            } else {
                ToolHelper.setDamage(itemStack, 0);
            }
        }
        return amount;
    }

    @Override
    public double getCharge(ItemStack itemStack) {
        return this.discharge(itemStack, 2.147483647E9, Integer.MAX_VALUE, true, false, true);
    }

    @Override
    public boolean canUse(ItemStack itemStack, double amount) {
        return this.getCharge(itemStack) >= this.applyEnchantmentEffect(itemStack, amount);
    }

    @Override
    public boolean use(ItemStack itemStack, double amount, EntityLivingBase entity) {
        if (!IC2.platform.isSimulating()) {
            return false;
        }
        amount = this.applyEnchantmentEffect(itemStack, amount);
        this.chargeFromArmor(itemStack, entity);
        double transfer = this.discharge(itemStack, amount, Integer.MAX_VALUE, true, false, true);
        FMLLog.getLogger().info("Test: " + transfer);
        if ((int)transfer == (int)amount) {
            this.discharge(itemStack, amount, Integer.MAX_VALUE, true, false, false);
            this.chargeFromArmor(itemStack, entity);
            if (entity instanceof EntityPlayer) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyUsedEvent((EntityPlayer)entity, itemStack, (int)amount));
            }
            return true;
        }
        return false;
    }

    @Override
    public void chargeFromArmor(ItemStack itemStack, EntityLivingBase entity) {
        IBaublesPlugin plugin;
        if (!IC2.platform.isSimulating() || entity == null) {
            return;
        }
        boolean inventoryChanged = false;
        if (entity instanceof EntityPlayer && (plugin = IC2.loader.getPlugin("baubles", IBaublesPlugin.class)) != null) {
            inventoryChanged = plugin.chargeFromArmor((EntityPlayer)entity, itemStack);
        }
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            IElectricItem armorItem;
            ItemStack armorItemStack;
            if (slot.func_188453_a() == EntityEquipmentSlot.Type.HAND || !((armorItemStack = entity.func_184582_a(slot)).func_77973_b() instanceof IElectricItem) || !(armorItem = (IElectricItem)armorItemStack.func_77973_b()).canProvideEnergy(armorItemStack) || armorItem.getTier(armorItemStack) < ((IElectricItem)itemStack.func_77973_b()).getTier(itemStack)) continue;
            double transfer = this.charge(itemStack, 2.147483647E9, Integer.MAX_VALUE, true, true);
            if (!((transfer = ElectricItem.manager.discharge(armorItemStack, transfer, Integer.MAX_VALUE, true, true, false)) > 0.0)) continue;
            this.charge(itemStack, transfer, Integer.MAX_VALUE, true, false);
            inventoryChanged = true;
        }
        if (inventoryChanged && entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).field_71070_bA.func_75142_b();
        }
    }

    @Override
    public String getToolTip(ItemStack itemStack) {
        return (int)this.getCharge(itemStack) + "/" + (int)this.getMaxCharge(itemStack) + " EU";
    }

    public double applyEnchantmentEffect(ItemStack item, double amount) {
        double effect;
        int level = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)item);
        if (level > 0) {
            effect = 1.0 + 0.15 * (double)level;
            amount *= effect;
        }
        if ((level = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)item)) > 0) {
            effect = 1.0 - 0.1 * (double)level;
            amount *= effect;
        }
        return amount;
    }

    @Override
    public double getMaxCharge(ItemStack stack) {
        return ((IElectricItem)stack.func_77973_b()).getMaxCharge(stack);
    }

    @Override
    public int getTier(ItemStack stack) {
        return ((IElectricItem)stack.func_77973_b()).getTier(stack);
    }

    private int calculateDamage(ItemStack stack, int newCharge) {
        if (stack.func_190926_b() || ToolHelper.getMaxDamage(stack) < 2) {
            return 0;
        }
        double maxCharge = this.getMaxCharge(stack);
        return (int)((1.0 + maxCharge - (double)newCharge) * (double)(ToolHelper.getMaxDamage(stack) - 1) / maxCharge);
    }

    public static int chargeArmor(EntityPlayer player, int provided) {
        IBaublesPlugin plugin;
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            if (provided <= 0) break;
            if (slot.func_188453_a() == EntityEquipmentSlot.Type.HAND) continue;
            provided = (int)((double)provided - ElectricItem.manager.charge(player.func_184582_a(slot), provided, Integer.MAX_VALUE, false, false));
        }
        if (provided > 0 && (plugin = IC2.loader.getPlugin("baubles", IBaublesPlugin.class)) != null) {
            IHasInventory inv = plugin.getBaublesInventory(player);
            for (int i = 0; i < inv.getSlotCount() && (provided = (int)((double)provided - ElectricItem.manager.charge(inv.getStackInSlot(i), provided, Integer.MAX_VALUE, false, false))) > 0; ++i) {
            }
        }
        return provided;
    }
}

