/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor.electric;

import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.inventory.base.IHandHeldInventory;
import ic2.core.inventory.base.IHasGui;
import ic2.core.item.armor.base.ItemArmorElectricJetpackBase;
import ic2.core.item.armor.base.ItemArmorJetpackBase;
import ic2.core.item.inv.inventories.NuclearJetpackInventory;
import ic2.core.item.inv.logics.NuclearJetpackLogic;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class ItemArmorNuclearJetpack
extends ItemArmorElectricJetpackBase
implements IHandHeldInventory {
    public ItemArmorNuclearJetpack(int index) {
        super(index, EntityEquipmentSlot.CHEST);
        this.setUnlocalizedName(Ic2ItemLang.jetpackNuclear);
    }

    @Override
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        List<String> altTip = sortedTooltip.get((Object)ToolTipType.Alt);
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        altTip.add(Ic2InfoLang.jetpackNuclearHeat.getLocalizedFormatted(nbt.func_74762_e("Heat"), nbt.func_74762_e("MaxHeat")));
        altTip.add(Ic2InfoLang.jetpackNuclearCompHeat.getLocalizedFormatted(100 - nbt.func_74762_e("ComponentHeat") + "%"));
    }

    @Override
    public boolean canDisable(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxCharge(ItemStack stack) {
        return 30000.0;
    }

    @Override
    public int getTier(ItemStack stack) {
        return 1;
    }

    @Override
    public double getTransferLimit(ItemStack stack) {
        return 0.0;
    }

    @Override
    public boolean canDoRocketMode(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canDoAdvHoverMode(ItemStack stack) {
        return true;
    }

    @Override
    public boolean isElectricJetpack(ItemStack stack) {
        return true;
    }

    @Override
    public float getPower(ItemStack stack) {
        return 0.95f;
    }

    @Override
    public float getThruster(ItemStack stack, ItemArmorJetpackBase.HoverMode mode) {
        switch (mode) {
            case Adv: {
                return 1.5f;
            }
            case Basic: {
                return 1.0f;
            }
            case None: {
                return 0.5f;
            }
        }
        return 0.5f;
    }

    @Override
    public float getDropPercentage(ItemStack stack) {
        return 0.05f;
    }

    @Override
    public int getMaxHeight(ItemStack stack, int worldHeight) {
        return (int)((float)worldHeight / 1.1f);
    }

    @Override
    public int getMaxRocketCharge(ItemStack stack) {
        return 25000;
    }

    @Override
    public int getFuelCost(ItemStack stack, ItemArmorJetpackBase.HoverMode mode) {
        switch (mode) {
            case None: {
                return 12;
            }
            case Basic: {
                return 9;
            }
            case Adv: {
                return 12;
            }
        }
        return 12;
    }

    @Override
    public void useEnergy(EntityPlayer player, ItemStack stack, int amount) {
        ElectricItem.manager.discharge(stack, amount, Integer.MAX_VALUE, true, false, false);
    }

    @Override
    public String getTexture() {
        return "ic2:textures/models/armor/jetpack_Nuclear";
    }

    @Override
    public IHasGui getInventory(EntityPlayer player, EnumHand hand, ItemStack stack) {
        return new NuclearJetpackInventory(player, this, stack);
    }

    @Override
    public int getGuiId(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        if (nbt.func_74764_b("GuiID")) {
            return nbt.func_74762_e("GuiID");
        }
        return -1;
    }

    @Override
    public void setGuiID(ItemStack stack, int id) {
        if (id == -1) {
            StackUtil.getOrCreateNbtData(stack).func_82580_o("GuiID");
            return;
        }
        StackUtil.getOrCreateNbtData(stack).func_74768_a("GuiID", id);
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        super.onArmorTick(world, player, stack);
        if (IC2.platform.isRendering()) {
            return;
        }
        NuclearJetpackLogic logic = this.getLogic(player, stack);
        logic.onTick(stack);
        logic.save(stack);
    }

    public NuclearJetpackLogic getLogic(EntityPlayer player, ItemStack stack) {
        return new NuclearJetpackLogic(stack, player, this.field_77881_a);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (playerIn.func_70093_af()) {
            if (IC2.platform.isSimulating()) {
                IC2.platform.launchGui(playerIn, this.getInventory(playerIn, hand, playerIn.func_184586_b(hand)), hand);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(hand));
        }
        return super.func_77659_a(worldIn, playerIn, hand);
    }
}

