/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.slots;

import ic2.api.classic.item.IMachineUpgradeItem;
import ic2.api.classic.tile.IMachine;
import ic2.core.IC2;
import ic2.core.block.base.tile.TileEntityAdvancedMachine;
import ic2.core.block.base.tile.TileEntityBasicElectricMachine;
import ic2.core.block.base.tile.TileEntityChargePadBase;
import ic2.core.block.base.util.FakeMachine;
import ic2.core.block.machine.low.TileEntityCanner;
import ic2.core.block.machine.low.TileEntityCropAnalyzer;
import ic2.core.block.machine.low.TileEntityMachineBuffer;
import ic2.core.block.machine.low.TileEntityMachineTank;
import ic2.core.block.machine.med.TileEntityVacuumCanner;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.slots.SlotBase;
import ic2.core.platform.textures.Ic2Icons;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SlotUpgrade
extends SlotBase {
    public static Map<IMachineUpgradeItem.UpgradeType, List<Integer>> upgradeTextures = new EnumMap<IMachineUpgradeItem.UpgradeType, List<Integer>>(IMachineUpgradeItem.UpgradeType.class);
    IMachine machine;
    TileEntity owner;
    int tex;

    public SlotUpgrade(IHasInventory par1, int par2, int par3, int par4, IMachine par5, TileEntity par6) {
        super(par1, par2, par3, par4);
        this.machine = par5;
        this.owner = par6;
        this.tex = -1;
    }

    public SlotUpgrade(IMachine par1, int par2, int par3, int par4) {
        super((IHasInventory)((Object)par1), par2, par3, par4);
        this.machine = par1;
        ArrayList textures = new ArrayList();
        for (IMachineUpgradeItem.UpgradeType type : this.machine.getSupportedTypes()) {
            textures.addAll(upgradeTextures.getOrDefault((Object)type, new ArrayList()));
        }
        this.tex = textures.size() > 0 ? (Integer)textures.get(IC2.random.nextInt(textures.size())) : -1;
    }

    public boolean func_75214_a(ItemStack par1) {
        IMachineUpgradeItem item;
        IMachineUpgradeItem.UpgradeType type;
        return !par1.func_190926_b() && par1.func_77973_b() instanceof IMachineUpgradeItem && (type = (item = (IMachineUpgradeItem)par1.func_77973_b()).getType(par1)) != null && this.machine.getSupportedTypes().contains((Object)type);
    }

    public boolean func_82869_a(EntityPlayer playerIn) {
        IMachineUpgradeItem upgrade;
        ItemStack stack = this.func_75211_c();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IMachineUpgradeItem && (upgrade = (IMachineUpgradeItem)stack.func_77973_b()).getExtraTier(stack, this.machine) > 0) {
            return IC2.keyboard.isAltKeyDown(playerIn);
        }
        return super.func_82869_a(playerIn);
    }

    @Override
    public void func_75218_e() {
        if (IC2.platform.isSimulating()) {
            if (this.machine instanceof TileEntityBasicElectricMachine) {
                ((TileEntityBasicElectricMachine)this.machine).setOverclockRates();
            } else if (this.machine instanceof TileEntityAdvancedMachine) {
                ((TileEntityAdvancedMachine)this.machine).setOverclockRates();
            } else if (this.machine instanceof TileEntityCanner) {
                ((TileEntityCanner)this.machine).setOverclockRates();
            } else if (this.machine instanceof TileEntityVacuumCanner) {
                ((TileEntityVacuumCanner)this.machine).setOverclockRates();
            } else if (this.machine instanceof TileEntityCropAnalyzer) {
                ((TileEntityCropAnalyzer)this.machine).setOverclockerRates();
            } else if (this.machine instanceof TileEntityMachineBuffer) {
                ((TileEntityMachineBuffer)this.machine).setOverclockRates();
            } else if (this.machine instanceof TileEntityMachineTank) {
                ((TileEntityMachineTank)this.machine).setOverclockRates();
            } else if (this.machine instanceof FakeMachine && this.owner instanceof TileEntityChargePadBase) {
                ((TileEntityChargePadBase)this.owner).setUpgradeStats();
            }
        }
        super.func_75218_e();
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getBackgroundSprite() {
        if (this.tex < 0) {
            return super.getBackgroundSprite();
        }
        return Ic2Icons.getTextures("slots")[this.tex];
    }

    public IMachine getMachine() {
        return this.machine;
    }
}

