/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.entity.boat;

import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.registry.Ic2Lang;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityClassicBoat
extends Entity {
    private static final DataParameter<Integer> TIME_SINCE_HIT = EntityDataManager.func_187226_a(EntityClassicBoat.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> FORWARD_DIRECTION = EntityDataManager.func_187226_a(EntityClassicBoat.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DAMAGE_TAKEN = EntityDataManager.func_187226_a(EntityClassicBoat.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ROTATION = EntityDataManager.func_187226_a(EntityClassicBoat.class, (DataSerializer)DataSerializers.field_187193_c);
    private boolean isBoatEmpty = true;
    private double speedMultiplier = 0.07;
    private int boatPosRotationIncrements;
    private double boatX;
    private double boatY;
    private double boatZ;
    private double boatYaw;
    private double boatPitch;
    @SideOnly(value=Side.CLIENT)
    private double velocityX;
    @SideOnly(value=Side.CLIENT)
    private double velocityY;
    @SideOnly(value=Side.CLIENT)
    private double velocityZ;
    public float yOffset;

    public EntityClassicBoat(World world) {
        super(world);
        this.field_70156_m = true;
        this.func_70105_a(1.5f, 0.6f);
        this.yOffset = this.field_70131_O / 2.0f;
    }

    public EntityClassicBoat(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y + this.func_70033_W(), z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public LocaleComp getNameComponent() {
        return Ic2Lang.nullKey;
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        return this.getNameComponent().getLocalized();
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(TIME_SINCE_HIT, (Object)0);
        this.field_70180_af.func_187214_a(FORWARD_DIRECTION, (Object)1);
        this.field_70180_af.func_187214_a(DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(ROTATION, (Object)new Float(0.0f));
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return entity.func_70046_E();
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public boolean func_70104_M() {
        return true;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.0 - (double)0.3f;
    }

    public double func_70033_W() {
        return this.yOffset + 1.0f;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.field_70178_ae && source.func_76347_k()) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag;
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + damage * 10.0f);
            this.func_70018_K();
            boolean bl = flag = source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.getDamageTaken() > 40.0f) {
                if (this.getRider() != null) {
                    this.getRider().func_184220_m((Entity)this);
                }
                if (!flag) {
                    this.onPlayerBreaking();
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70057_ab() {
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11.0f);
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        if (this.isBoatEmpty) {
            this.boatPosRotationIncrements = posRotationIncrements + 5;
        } else {
            double d3 = x - this.field_70165_t;
            double d4 = y - this.field_70163_u;
            double d5 = z - this.field_70161_v;
            double d6 = d3 * d3 + d4 * d4 + d5 * d5;
            if (d6 <= 1.0) {
                return;
            }
            this.boatPosRotationIncrements = 3;
        }
        this.boatX = x;
        this.boatY = y;
        this.boatZ = z;
        this.boatYaw = yaw;
        this.boatPitch = pitch;
        this.field_70159_w = this.velocityX;
        this.field_70181_x = this.velocityY;
        this.field_70179_y = this.velocityZ;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.velocityX = this.field_70159_w = x;
        this.velocityY = this.field_70181_x = y;
        this.velocityZ = this.field_70179_y = z;
    }

    public void func_70071_h_() {
        double d12;
        double d11;
        double d4;
        double d2;
        super.func_70071_h_();
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        int b0 = 5;
        double d0 = 0.0;
        for (int i = 0; i < b0; ++i) {
            AxisAlignedBB enityBox = this.func_174813_aQ();
            double minY = enityBox.field_72338_b + (enityBox.field_72337_e - enityBox.field_72338_b) * (double)(i + 0) / (double)b0 - 0.125;
            double maxY = enityBox.field_72338_b + (enityBox.field_72337_e - enityBox.field_72338_b) * (double)(i + 1) / (double)b0 - 0.125;
            AxisAlignedBB box = new AxisAlignedBB(enityBox.field_72340_a, minY, enityBox.field_72339_c, enityBox.field_72336_d, maxY, enityBox.field_72334_f);
            if (!this.isOnWater(box)) continue;
            d0 += 1.0 / (double)b0;
        }
        double d10 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        if (d10 > 0.26249999999999996) {
            d2 = Math.cos((double)this.field_70177_z * Math.PI / 180.0);
            d4 = Math.sin((double)this.field_70177_z * Math.PI / 180.0);
            int j = 0;
            while ((double)j < 1.0 + d10 * 60.0) {
                double d9;
                double d8;
                double d5 = this.field_70146_Z.nextFloat() * 2.0f - 1.0f;
                double d6 = (double)(this.field_70146_Z.nextInt(2) * 2 - 1) * 0.7;
                if (this.field_70146_Z.nextBoolean()) {
                    d8 = this.field_70165_t - d2 * d5 * 0.8 + d4 * d6;
                    d9 = this.field_70161_v - d4 * d5 * 0.8 - d2 * d6;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, d8, this.field_70163_u - 0.125, d9, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                } else {
                    d8 = this.field_70165_t + d2 + d4 * d5 * 0.7;
                    d9 = this.field_70161_v + d4 - d2 * d5 * 0.7;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, d8, this.field_70163_u - 0.125, d9, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
                ++j;
            }
        }
        if (this.field_70170_p.field_72995_K && this.isBoatEmpty) {
            if (this.boatPosRotationIncrements > 0) {
                d2 = this.field_70165_t + (this.boatX - this.field_70165_t) / (double)this.boatPosRotationIncrements;
                d4 = this.field_70163_u + (this.boatY - this.field_70163_u) / (double)this.boatPosRotationIncrements;
                d11 = this.field_70161_v + (this.boatZ - this.field_70161_v) / (double)this.boatPosRotationIncrements;
                d12 = MathHelper.func_76138_g((double)(this.boatYaw - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + d12 / (double)this.boatPosRotationIncrements);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.boatPitch - (double)this.field_70125_A) / (double)this.boatPosRotationIncrements);
                --this.boatPosRotationIncrements;
                this.func_70107_b(d2, d4, d11);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            } else {
                d2 = this.field_70165_t + this.field_70159_w;
                d4 = this.field_70163_u + this.field_70181_x;
                d11 = this.field_70161_v + this.field_70179_y;
                this.func_70107_b(d2, d4, d11);
                if (this.field_70122_E) {
                    Block block = this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_177230_c();
                    this.field_70159_w *= (double)block.field_149765_K;
                    this.field_70181_x *= (double)block.field_149765_K;
                    this.field_70179_y *= (double)block.field_149765_K;
                }
                this.field_70159_w *= (double)0.99f;
                this.field_70181_x *= (double)0.95f;
                this.field_70179_y *= (double)0.99f;
            }
        } else {
            if (d0 < 1.0) {
                d2 = d0 * 2.0 - 1.0;
                this.field_70181_x += (double)0.04f * d2;
            } else {
                if (this.field_70181_x < 0.0) {
                    this.field_70181_x /= 2.0;
                }
                this.field_70181_x += (double)0.007f;
            }
            Entity rider = this.getRider();
            if (rider instanceof EntityLivingBase) {
                EntityLivingBase entitylivingbase = (EntityLivingBase)rider;
                float f = rider.field_70177_z + -entitylivingbase.field_70702_br * 90.0f;
                double maxSpeed = this.getSpeed(entitylivingbase);
                double lastX = this.field_70159_w;
                double lastZ = this.field_70179_y;
                this.field_70159_w += -Math.sin(f * (float)Math.PI / 180.0f) * this.speedMultiplier * maxSpeed * (double)0.05f;
                this.field_70179_y += Math.cos(f * (float)Math.PI / 180.0f) * this.speedMultiplier * maxSpeed * (double)0.05f;
                if (lastX - this.field_70159_w != 0.0 || lastZ - this.field_70179_y != 0.0) {
                    this.field_70177_z = (rider.field_70177_z - 90.0f) % 360.0f;
                }
            } else if (this.hasAfkSpeed()) {
                float f = this.field_70177_z + 90.0f;
                double maxSpeed = this.getAfkSpeed();
                this.field_70159_w += -Math.sin(f * (float)Math.PI / 180.0f) * this.speedMultiplier * maxSpeed * (double)0.05f;
                this.field_70179_y += Math.cos(f * (float)Math.PI / 180.0f) * this.speedMultiplier * maxSpeed * (double)0.05f;
            }
            d2 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            if (d2 > this.getTopSpeed()) {
                d4 = this.getTopSpeed() / d2;
                this.field_70159_w *= d4;
                this.field_70179_y *= d4;
                d2 = this.getTopSpeed();
            }
            if (d2 > d10 && this.speedMultiplier < 0.35) {
                this.speedMultiplier += (0.35 - this.speedMultiplier) / 35.0;
                if (this.speedMultiplier > 0.35) {
                    this.speedMultiplier = 0.35;
                }
            } else {
                this.speedMultiplier -= (this.speedMultiplier - 0.07) / 35.0;
                if (this.speedMultiplier < 0.07) {
                    this.speedMultiplier = 0.07;
                }
            }
            for (int l = 0; l < 4; ++l) {
                int i1 = MathHelper.func_76128_c((double)(this.field_70165_t + ((double)(l % 2) - 0.5) * 0.8));
                int j = MathHelper.func_76128_c((double)(this.field_70161_v + ((double)(l / 2) - 0.5) * 0.8));
                for (int j1 = 0; j1 < 2; ++j1) {
                    int k = MathHelper.func_76128_c((double)this.field_70163_u) + j1;
                    BlockPos pos = new BlockPos(i1, k, j);
                    IBlockState state = this.field_70170_p.func_180495_p(pos);
                    if (state.func_177230_c() == Blocks.field_150431_aC) {
                        this.field_70170_p.func_175698_g(pos);
                        this.field_70123_F = false;
                        continue;
                    }
                    if (state.func_177230_c() != Blocks.field_150392_bi) continue;
                    this.field_70170_p.func_175655_b(pos, true);
                    this.field_70123_F = false;
                }
            }
            if (this.field_70122_E) {
                this.field_70159_w *= 0.5;
                this.field_70181_x *= 0.5;
                this.field_70179_y *= 0.5;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            if (this.field_70123_F && d10 > this.getMaxRammingSpeed()) {
                if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                    this.onRammingBreaking(d10);
                    this.func_70106_y();
                }
            } else {
                this.field_70159_w *= (double)0.99f;
                this.field_70181_x *= (double)0.95f;
                this.field_70179_y *= (double)0.99f;
            }
            this.field_70125_A = 0.0f;
            d11 = this.field_70159_w;
            d12 = this.field_70179_y;
            if (d11 * d11 + d12 * d12 > 0.001) {
                double d = (float)(Math.atan2(d12, d11) * 180.0 / Math.PI);
            }
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70180_af.func_187227_b(ROTATION, (Object)Float.valueOf(this.field_70177_z));
                List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b((double)0.2f, 0.0, (double)0.2f));
                if (list != null && !list.isEmpty()) {
                    for (int k1 = 0; k1 < list.size(); ++k1) {
                        Entity entity = (Entity)list.get(k1);
                        if (entity == rider || !entity.func_70104_M() || !(entity instanceof EntityBoat) && !(entity instanceof EntityClassicBoat)) continue;
                        entity.func_70108_f((Entity)this);
                    }
                }
                if (rider != null && rider.field_70128_L) {
                    rider = null;
                }
            } else {
                this.func_70101_b(((Float)this.field_70180_af.func_187225_a(ROTATION)).floatValue(), this.field_70125_A);
            }
        }
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float f = 0.0f;
            float f1 = (float)((this.field_70128_L ? (double)0.01f : this.func_70042_X()) + passenger.func_70033_W());
            Vec3d vec3d = new Vec3d((double)f, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.field_70165_t + vec3d.field_72450_a, this.field_70163_u + (double)f1, this.field_70161_v + vec3d.field_72449_c);
        }
    }

    protected void func_70014_b(NBTTagCompound p_70014_1_) {
    }

    protected void func_70037_a(NBTTagCompound p_70037_1_) {
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadowSize() {
        return 0.0f;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        Entity rider = this.getRider();
        if (rider instanceof EntityPlayer && rider != player) {
            return false;
        }
        if (!player.func_70093_af() && !this.field_70170_p.field_72995_K) {
            player.func_184220_m((Entity)this);
        }
        return true;
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 1;
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        if (onGroundIn) {
            if (this.field_70143_R > 3.0f) {
                this.func_180430_e(this.field_70143_R, 1.0f);
                if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                    this.onFallingBreaking(this.field_70143_R);
                    this.func_70106_y();
                }
                this.field_70143_R = 0.0f;
            }
        } else if (state.func_185904_a() != Material.field_151586_h && y < 0.0) {
            this.field_70143_R = (float)((double)this.field_70143_R - y);
        }
    }

    public void setDamageTaken(float p_70266_1_) {
        this.field_70180_af.func_187227_b(DAMAGE_TAKEN, (Object)Float.valueOf(p_70266_1_));
    }

    public float getDamageTaken() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE_TAKEN)).floatValue();
    }

    public void setTimeSinceHit(int p_70265_1_) {
        this.field_70180_af.func_187227_b(TIME_SINCE_HIT, (Object)p_70265_1_);
    }

    public int getTimeSinceHit() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_SINCE_HIT);
    }

    public void setForwardDirection(int p_70269_1_) {
        this.field_70180_af.func_187227_b(FORWARD_DIRECTION, (Object)p_70269_1_);
    }

    public int getForwardDirection() {
        return (Integer)this.field_70180_af.func_187225_a(FORWARD_DIRECTION);
    }

    @SideOnly(value=Side.CLIENT)
    public void setIsBoatEmpty(boolean p_70270_1_) {
        this.isBoatEmpty = p_70270_1_;
    }

    public float getSpeed(EntityLivingBase base) {
        return base.field_191988_bg;
    }

    public boolean hasAfkSpeed() {
        return false;
    }

    public float getAfkSpeed() {
        return 0.0f;
    }

    public void onPlayerBreaking() {
        this.func_70099_a(this.getItem(), 0.0f);
    }

    public void onFallingBreaking(float fallingDistance) {
    }

    public void onRammingBreaking(double speed) {
    }

    public double getMaxRammingSpeed() {
        return 0.2;
    }

    public double getTopSpeed() {
        return 0.35;
    }

    protected boolean isOnWater(AxisAlignedBB aabb) {
        return this.field_70170_p.func_72875_a(aabb, Material.field_151586_h);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return this.getItem();
    }

    public abstract ItemStack getItem();

    public abstract ResourceLocation getTexture();

    public Entity getRider() {
        List entity = this.func_184188_bt();
        if (entity.size() > 0) {
            return (Entity)entity.get(0);
        }
        return null;
    }
}

