/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low.logic.crops;

import ic2.api.classic.crops.ClassicCrops;
import ic2.api.crops.CropCard;
import ic2.core.block.machine.low.logic.crops.SeedEntry;
import java.util.Objects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class CropSeedEntry
extends SeedEntry {
    CropCard card;
    SeedEntry seed;
    final int hashCode;

    public CropSeedEntry(NBTTagCompound nbt) {
        this.seed = new SeedEntry(nbt);
        this.card = this.getData(nbt.func_74779_i("ID"));
        this.hashCode = Objects.hash(this.seed, this.card);
    }

    public CropSeedEntry(SeedEntry entry, CropCard crop) {
        this.seed = entry;
        this.card = crop;
        this.hashCode = Objects.hash(this.seed, this.card);
    }

    private CropCard getData(String id) {
        return ClassicCrops.instance.getCropCard(new ResourceLocation(id));
    }

    @Override
    public NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = super.writeToNBT();
        nbt.func_74778_a("ID", new ResourceLocation(this.card.getOwner(), this.card.getId()).toString());
        return nbt;
    }

    @Override
    public CropCard getCard(CropCard crop) {
        return this.card;
    }

    @Override
    public void combine(SeedEntry entry) {
        this.seed.combine(entry);
    }

    @Override
    public int consume(int requested, boolean doDrain) {
        return this.seed.consume(requested, doDrain);
    }

    @Override
    public boolean isEmpty() {
        return this.seed.isEmpty();
    }

    @Override
    public byte getGain() {
        return this.seed.getGain();
    }

    @Override
    public byte getGrowth() {
        return this.seed.getGrowth();
    }

    @Override
    public byte getResistance() {
        return this.seed.getResistance();
    }

    @Override
    public int getAmount() {
        return this.seed.getAmount();
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    public SeedEntry getEntry() {
        return this.seed;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CropSeedEntry) {
            CropSeedEntry entry = (CropSeedEntry)obj;
            return Objects.equals(this.card, entry.card) && this.seed.equals(entry.seed);
        }
        return false;
    }
}

