/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.base.util.info;

import ic2.api.classic.tile.IInfoTile;
import ic2.api.classic.tile.machine.IEUStorage;
import ic2.core.block.base.util.info.misc.IProbeComponent;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.player.PlayerHandler;
import java.awt.Color;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Optional;

public class EnergyInfo
implements IProbeComponent {
    IEUStorage storage;

    public EnergyInfo(IEUStorage eu) {
        this.storage = eu;
    }

    @Override
    public String getDisplayText(EntityPlayer player) {
        int max = this.storage.getMaxEU();
        int eu = this.storage.getStoredEU();
        if (eu > max) {
            eu = max;
        }
        return Ic2InfoLang.euStorage.getLocalizedFormatted(eu, max);
    }

    @Override
    public boolean canShow(EntityPlayer player) {
        return PlayerHandler.getClientPlayerHandler().hasEUReader();
    }

    @Override
    public IInfoTile.InfoType getType() {
        return IInfoTile.InfoType.EUStorage;
    }

    @Override
    @Optional.Method(modid="theoneprobe")
    public boolean isModeValid(ProbeMode mode, PlayerHandler handler) {
        return mode != ProbeMode.NORMAL && handler.hasEUReader();
    }

    @Override
    @Optional.Method(modid="theoneprobe")
    public void applyInfo(IProbeInfo info, EntityPlayer player, EnumFacing side) {
        int max = this.storage.getMaxEU();
        int eu = this.storage.getStoredEU();
        if (eu > max) {
            eu = max;
        }
        info.progress(eu, max, info.defaultProgressStyle().filledColor(Color.BLUE.getRGB()).suffix(" EU"));
    }
}

