/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import openblocks.common.block.BlockBlockManpulatorBase;
import openmods.api.INeighbourAwareTile;
import openmods.tileentity.OpenTileEntity;

public abstract class TileEntityBlockManipulator
extends OpenTileEntity
implements INeighbourAwareTile,
ITickable {
    private static final int EVENT_ACTIVATE = 3;
    private int actionCount = 0;

    protected abstract int getActionLimit();

    public void func_73660_a() {
        IBlockState blockState;
        boolean checkForWork = this.actionCount > 0;
        this.actionCount = 0;
        if (checkForWork && (blockState = this.field_145850_b.func_180495_p(this.func_174877_v())).func_177230_c() == this.func_145838_q() && ((Boolean)blockState.func_177229_b(BlockBlockManpulatorBase.POWERED)).booleanValue()) {
            this.triggerBlockAction(blockState);
        }
    }

    public void onNeighbourChanged(BlockPos neighbourPos, Block neighbourBlock) {
        IBlockState state;
        if (this.actionCount > this.getActionLimit()) {
            return;
        }
        if (!this.field_145850_b.field_72995_K && (state = this.field_145850_b.func_180495_p(this.func_174877_v())).func_177230_c() == this.func_145838_q()) {
            boolean isPowered = this.field_145850_b.func_175687_A(this.func_174877_v()) > 0;
            IBlockState newState = state.func_177226_a(BlockBlockManpulatorBase.POWERED, (Comparable)Boolean.valueOf(isPowered));
            if (newState != state) {
                this.field_145850_b.func_180501_a(this.func_174877_v(), newState, 2);
                this.playSoundAtBlock(isPowered ? SoundEvents.field_187715_dR : SoundEvents.field_187712_dQ, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.15f + 0.6f);
            }
            if (isPowered) {
                this.triggerBlockAction(newState);
            }
        }
    }

    protected void triggerBlockAction() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.triggerBlockAction(state);
    }

    protected void triggerBlockAction(IBlockState state) {
        IBlockState targetState;
        EnumFacing direction = this.getFront(state);
        BlockPos target = this.field_174879_c.func_177972_a(direction);
        if (this.field_145850_b.func_175667_e(target) && this.canWork(targetState = this.field_145850_b.func_180495_p(target), target, direction)) {
            this.sendBlockEvent(3, 0);
            ++this.actionCount;
        }
    }

    public boolean func_145842_c(int event, int param) {
        if (event == 3) {
            this.doWork();
            return true;
        }
        return false;
    }

    private void doWork() {
        IBlockState targetState;
        EnumFacing direction;
        BlockPos target;
        if (this.field_145850_b instanceof WorldServer && this.field_145850_b.func_175667_e(target = this.field_174879_c.func_177972_a(direction = this.getFront())) && this.canWork(targetState = this.field_145850_b.func_180495_p(target), target, direction)) {
            this.doWork(targetState, target, direction);
        }
    }

    protected abstract boolean canWork(IBlockState var1, BlockPos var2, EnumFacing var3);

    protected abstract void doWork(IBlockState var1, BlockPos var2, EnumFacing var3);
}

