/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.preview.data;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.World;
import pregenerator.impl.client.preview.data.ITask;
import pregenerator.impl.client.preview.world.ChunkCache;
import pregenerator.impl.client.preview.world.WorldSeed;

public class MapManager
implements Runnable {
    Thread thread;
    boolean running = true;
    Map<Integer, ChunkCache> dimensions = new ConcurrentHashMap<Integer, ChunkCache>();

    public MapManager() {
        this.thread = new Thread((Runnable)this, "FileManager");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void shutdown() {
        if (!this.running) {
            return;
        }
        this.running = false;
        try {
            this.thread.interrupt();
            while (this.thread.isAlive()) {
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {}
            }
            this.thread = null;
            for (ChunkCache dim : this.dimensions.values()) {
                dim.close();
            }
            this.dimensions.clear();
            System.gc();
        }
        catch (Exception e) {
            if (!this.running) {
                return;
            }
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                for (ChunkCache dim : this.dimensions.values()) {
                    dim.update();
                }
                Thread.sleep(1L);
            }
            catch (Exception e) {
                if (!this.running) {
                    return;
                }
                e.printStackTrace();
            }
        }
    }

    public ChunkCache createDimension(int dim) {
        ChunkCache cache = this.dimensions.get(dim);
        if (cache == null) {
            try {
                WorldSeed.getMapFolder().mkdirs();
                File chunk = new File(WorldSeed.getMapFolder(), "Chunk_DIM_" + dim);
                File height = new File(WorldSeed.getMapFolder(), "Height_DIM_" + dim);
                cache = new ChunkCache(chunk, height);
                this.dimensions.put(dim, cache);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return cache;
    }

    public void removeDimension(int dimension) {
        ChunkCache cache = this.dimensions.remove(dimension);
        if (cache == null) {
            return;
        }
        cache.close();
    }

    public void addTask(World world, ITask task) {
        this.addTask(world.field_73011_w.getDimension(), task);
    }

    public void addTask(int dim, ITask task) {
        ChunkCache data = this.dimensions.get(dim);
        if (data == null) {
            return;
        }
        data.addTask(task);
    }
}

