/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client;

import net.minecraft.client.gui.ScaledResolution;

public enum ScreenPosition {
    NEGATIVE("Left", "Top"),
    CENTER("Center", "Center"),
    POSITIVE("Right", "Bottom");

    String xValue;
    String yValue;

    private ScreenPosition(String x, String y) {
        this.xValue = x;
        this.yValue = y;
    }

    public static ScreenPosition byXName(String name) {
        if (name.equalsIgnoreCase("Left")) {
            return NEGATIVE;
        }
        if (name.equalsIgnoreCase("Right")) {
            return POSITIVE;
        }
        return CENTER;
    }

    public static ScreenPosition byYName(String name) {
        if (name.equalsIgnoreCase("Top")) {
            return NEGATIVE;
        }
        if (name.equalsIgnoreCase("Bottom")) {
            return POSITIVE;
        }
        return CENTER;
    }

    public String getXName() {
        return this.xValue;
    }

    public String getYName() {
        return this.yValue;
    }

    public ScreenPosition getNext() {
        if (this == NEGATIVE) {
            return CENTER;
        }
        if (this == CENTER) {
            return POSITIVE;
        }
        return NEGATIVE;
    }

    public int getXPosition(ScaledResolution res, int width, boolean big) {
        if (big) {
            switch (this) {
                case CENTER: {
                    return (int)((double)res.func_78326_a() / 2.0) + 200;
                }
                case POSITIVE: {
                    return res.func_78326_a() + 80;
                }
            }
            return width * 3 + 20;
        }
        switch (this) {
            case CENTER: {
                return res.func_78326_a() / 2;
            }
            case POSITIVE: {
                return res.func_78326_a() - (width - 40);
            }
        }
        return 60;
    }

    public int getYPosition(ScaledResolution res, int height, ScreenPosition xPos, boolean big) {
        if (big) {
            switch (this) {
                case CENTER: {
                    return res.func_78328_b() / 2 + 50;
                }
                case POSITIVE: {
                    if (xPos == CENTER) {
                        return res.func_78328_b() - height / 2;
                    }
                    return res.func_78328_b() - 20;
                }
            }
            return height * 3 - 10;
        }
        switch (this) {
            case CENTER: {
                return res.func_78328_b() / 2;
            }
            case POSITIVE: {
                if (xPos == CENTER) {
                    return res.func_78328_b() - (height + 30);
                }
                return res.func_78328_b() - (height + 5);
            }
        }
        return 20;
    }
}

