/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.item;

import java.util.EnumSet;
import javax.annotation.Nonnull;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import tonius.simplyjetpacks.setup.ModItems;

public enum MetaItems {
    PARTICLE_DEFAULT("particle_default", "particle_customizers", EnumRarity.COMMON),
    PARTICLE_NONE("particle_none", "particle_customizers", EnumRarity.COMMON),
    PARTICLE_SMOKE("particle_smoke", "particle_customizers", EnumRarity.COMMON),
    PARTICLE_RAINBOW("particle_rainbow", "particle_customizers", EnumRarity.COMMON),
    LEATHER_STRAP("leather_strap", null, EnumRarity.COMMON);

    private final String name;
    private final String keyTooltip;
    private final EnumRarity rarity;
    private boolean glow;
    public static final EnumSet<MetaItems> PARTICLE_CUSTOMIZERS;

    private MetaItems(String name, String keyTooltip, EnumRarity rarity) {
        this.name = name;
        this.keyTooltip = keyTooltip;
        this.rarity = rarity;
    }

    private MetaItems(String name, String keyTooltip, EnumRarity rarity, boolean glow) {
        this(name, keyTooltip, rarity);
        this.glow = glow;
    }

    public static MetaItems getFromName(String s) {
        for (MetaItems meta : MetaItems.values()) {
            if (!meta.name.toLowerCase().equals(s.toLowerCase())) continue;
            return meta;
        }
        return null;
    }

    @Nonnull
    public static MetaItems getTypeFromMeta(int meta) {
        return MetaItems.values()[meta >= 0 && meta < MetaItems.values().length ? meta : 0];
    }

    @Nonnull
    public ItemStack getStackMetaItem() {
        return this.getStackMetaItem(1);
    }

    @Nonnull
    public ItemStack getStackMetaItem(int size) {
        return new ItemStack((Item)ModItems.metaItem, size, this.ordinal());
    }

    public String getName() {
        return this.name;
    }

    public String getKeyTooltip() {
        return this.keyTooltip;
    }

    public EnumRarity getRarity() {
        return this.rarity;
    }

    public boolean getGlow() {
        return this.glow;
    }

    static {
        PARTICLE_CUSTOMIZERS = EnumSet.range(PARTICLE_DEFAULT, PARTICLE_RAINBOW);
    }
}

