/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item.tool;

import cofh.core.item.IAOEBreakItem;
import cofh.core.util.RayTracer;
import cofh.redstonearsenal.item.tool.ItemToolFlux;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class ItemHammerFlux
extends ItemToolFlux
implements IAOEBreakItem {
    public ItemHammerFlux(Item.ToolMaterial toolMaterial) {
        super(-3.2f, toolMaterial);
        this.addToolClass("pickaxe");
        this.addToolClass("hammer");
        this.damage = 9;
        this.damageCharged = 6;
        this.energyPerUseCharged = 1600;
        this.field_150914_c.addAll((Collection)ItemPickaxe.field_150915_c);
        this.effectiveMaterials.add((Object)Material.field_151573_f);
        this.effectiveMaterials.add((Object)Material.field_151574_g);
        this.effectiveMaterials.add((Object)Material.field_151576_e);
        this.effectiveMaterials.add((Object)Material.field_151588_w);
        this.effectiveMaterials.add((Object)Material.field_151598_x);
        this.effectiveMaterials.add((Object)Material.field_151592_s);
        this.effectiveMaterials.add((Object)Material.field_151591_t);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        World world = player.field_70170_p;
        IBlockState state = world.func_180495_p(pos);
        if (state.func_185887_b(world, pos) == 0.0f) {
            return false;
        }
        if (!this.canHarvestBlock(state, stack)) {
            if (!player.field_71075_bZ.field_75098_d) {
                this.useEnergy(stack, false);
            }
            return false;
        }
        if (player.func_70093_af()) {
            if (!player.field_71075_bZ.field_75098_d) {
                this.useEnergy(stack, false);
            }
            return false;
        }
        float refStrength = state.func_185903_a(player, world, pos);
        float maxStrength = refStrength / 8.0f;
        if (refStrength != 0.0f) {
            RayTraceResult traceResult = RayTracer.retrace((EntityPlayer)player, (boolean)false);
            if (traceResult == null || traceResult.field_178784_b == null) {
                return false;
            }
            boolean used = false;
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            int radius = this.isEmpowered(stack) ? 2 : 1;
            switch (traceResult.field_178784_b) {
                case DOWN: 
                case UP: {
                    for (int i = x - radius; i <= x + radius; ++i) {
                        for (int k = z - radius; k <= z + radius; ++k) {
                            BlockPos adjPos;
                            IBlockState adjState;
                            float strength;
                            if (i == x && k == z || !((strength = (adjState = world.func_180495_p(adjPos = new BlockPos(i, y, k))).func_185903_a(player, world, adjPos)) > 0.0f) || !(strength >= maxStrength)) continue;
                            used |= this.harvestBlock(world, adjPos, player);
                        }
                    }
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    int posY = y;
                    y = y - 1 + radius;
                    for (int i = x - radius; i <= x + radius; ++i) {
                        for (int j = y - radius; j <= y + radius; ++j) {
                            BlockPos adjPos;
                            IBlockState adjState;
                            float strength;
                            if (i == x && j == posY || !((strength = (adjState = world.func_180495_p(adjPos = new BlockPos(i, j, z))).func_185903_a(player, world, adjPos)) > 0.0f) || !(strength >= maxStrength)) continue;
                            used |= this.harvestBlock(world, adjPos, player);
                        }
                    }
                    break;
                }
                case WEST: 
                case EAST: {
                    int posY = y;
                    y = y - 1 + radius;
                    for (int j = y - radius; j <= y + radius; ++j) {
                        for (int k = z - radius; k <= z + radius; ++k) {
                            BlockPos adjPos;
                            IBlockState adjState;
                            float strength;
                            if (j == posY && k == z || !((strength = (adjState = world.func_180495_p(adjPos = new BlockPos(x, j, k))).func_185903_a(player, world, adjPos)) > 0.0f) || !(strength >= maxStrength)) continue;
                            used |= this.harvestBlock(world, adjPos, player);
                        }
                    }
                    break;
                }
            }
            if (used && !player.field_71075_bZ.field_75098_d) {
                this.useEnergy(stack, false);
            }
        }
        return false;
    }

    public ImmutableList<BlockPos> getAOEBlocks(ItemStack stack, BlockPos pos, EntityPlayer player) {
        ArrayList<BlockPos> area = new ArrayList<BlockPos>();
        World world = player.func_130014_f_();
        RayTraceResult traceResult = RayTracer.retrace((EntityPlayer)player, (boolean)false);
        if (traceResult == null || traceResult.field_178784_b == null || !this.canHarvestBlock(world.func_180495_p(pos), stack) || player.func_70093_af()) {
            return ImmutableList.copyOf(area);
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int radius = this.isEmpowered(stack) ? 2 : 1;
        switch (traceResult.field_178784_b) {
            case DOWN: 
            case UP: {
                for (int i = x - radius; i <= x + radius; ++i) {
                    for (int k = z - radius; k <= z + radius; ++k) {
                        BlockPos harvestPos;
                        if (i == x && k == z || !this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(i, y, k)), stack)) continue;
                        area.add(harvestPos);
                    }
                }
                break;
            }
            case NORTH: 
            case SOUTH: {
                int posY = y;
                y = y - 1 + radius;
                for (int i = x - radius; i <= x + radius; ++i) {
                    for (int j = y - radius; j <= y + radius; ++j) {
                        BlockPos harvestPos;
                        if (i == x && j == posY || !this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(i, j, z)), stack)) continue;
                        area.add(harvestPos);
                    }
                }
                break;
            }
            case WEST: 
            case EAST: {
                int posY = y;
                y = y - 1 + radius;
                for (int j = y - radius; j <= y + radius; ++j) {
                    for (int k = z - radius; k <= z + radius; ++k) {
                        BlockPos harvestPos;
                        if (j == posY && k == z || !this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(x, j, k)), stack)) continue;
                        area.add(harvestPos);
                    }
                }
                break;
            }
        }
        return ImmutableList.copyOf(area);
    }
}

