/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client;

import com.google.common.base.Function;
import micdoodle8.mods.galacticraft.api.entity.ICameraZoomEntity;
import micdoodle8.mods.galacticraft.api.event.client.CelestialBodyRenderEvent;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class EventHandlerClient {
    public static Minecraft mc = FMLClientHandler.instance().getClient();
    public static boolean sneakRenderOverride;
    public static IBakedModel[] fluidPipeModels;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderPlayerPre(RenderPlayerEvent.Pre event) {
        Entity entity;
        float rotateOffset;
        GL11.glPushMatrix();
        EntityPlayer player = event.getEntityPlayer();
        if (player.func_184187_bx() instanceof ICameraZoomEntity && player == Minecraft.func_71410_x().field_71439_g && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 && (rotateOffset = ((ICameraZoomEntity)(entity = player.func_184187_bx())).getRotateOffset()) > -10.0f) {
            GL11.glTranslatef((float)0.0f, (float)(-(rotateOffset += ClientProxyCore.PLAYER_Y_OFFSET)), (float)0.0f);
            float anglePitch = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * event.getPartialRenderTick();
            float angleYaw = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * event.getPartialRenderTick();
            GL11.glRotatef((float)(-angleYaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)anglePitch, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)rotateOffset, (float)0.0f);
        }
        if (player instanceof EntityPlayerSP) {
            sneakRenderOverride = true;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderPlayerPost(RenderPlayerEvent.Post event) {
        GL11.glPopMatrix();
        if (event.getEntityPlayer() instanceof EntityPlayerSP) {
            sneakRenderOverride = false;
        }
    }

    @SubscribeEvent
    public void onRenderPlanetPre(CelestialBodyRenderEvent.Pre event) {
        if (event.celestialBody == GalacticraftCore.planetOverworld) {
            if (!ClientProxyCore.overworldTextureRequestSent) {
                GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_REQUEST_OVERWORLD_IMAGE, GCCoreUtil.getDimensionID((World)EventHandlerClient.mc.field_71441_e), new Object[0]));
                ClientProxyCore.overworldTextureRequestSent = true;
            }
            if (ClientProxyCore.overworldTexturesValid) {
                event.celestialBodyTexture = null;
                GlStateManager.func_179144_i((int)ClientProxyCore.overworldTextureClient.func_110552_b());
            }
        }
    }

    @SubscribeEvent
    public void onRenderPlanetPost(CelestialBodyRenderEvent.Post event) {
        if (EventHandlerClient.mc.field_71462_r instanceof GuiCelestialSelection) {
            if (event.celestialBody == GalacticraftCore.planetSaturn) {
                EventHandlerClient.mc.field_71446_o.func_110577_a(ClientProxyCore.saturnRingTexture);
                float size = (float)((GuiCelestialSelection)EventHandlerClient.mc.field_71462_r).getWidthForCelestialBody(event.celestialBody) / 6.0f;
                ((GuiCelestialSelection)EventHandlerClient.mc.field_71462_r).drawTexturedModalRect(-7.5f * size, -1.75f * size, 15.0f * size, 3.5f * size, 0.0f, 0.0f, 30.0f, 7.0f, false, false, 32.0f, 32.0f);
            } else if (event.celestialBody == GalacticraftCore.planetUranus) {
                EventHandlerClient.mc.field_71446_o.func_110577_a(ClientProxyCore.uranusRingTexture);
                float size = (float)((GuiCelestialSelection)EventHandlerClient.mc.field_71462_r).getWidthForCelestialBody(event.celestialBody) / 6.0f;
                ((GuiCelestialSelection)EventHandlerClient.mc.field_71462_r).drawTexturedModalRect(-1.75f * size, -7.0f * size, 3.5f * size, 14.0f * size, 0.0f, 0.0f, 7.0f, 28.0f, false, false, 32.0f, 32.0f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Post event) {
        EnumFacing[] enumFacingArray = EnumFacing.field_82609_l;
        int n = enumFacingArray.length;
        int n2 = 0;
        while (n2 < n) {
            EnumFacing facing = enumFacingArray[n2];
            try {
                Character c = Character.valueOf(Character.toLowerCase(facing.func_176610_l().charAt(0)));
                Class<ModelLoaderRegistry> clazz = ModelLoaderRegistry.class;
                // MONITORENTER : net.minecraftforge.client.model.ModelLoaderRegistry.class
                IModel model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("galacticraftcore", "block/fluid_pipe_pull_" + c));
                // MONITOREXIT : clazz
                Function spriteFunction = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                EventHandlerClient.fluidPipeModels[facing.ordinal()] = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, (java.util.function.Function)spriteFunction);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    static {
        fluidPipeModels = new IBakedModel[6];
    }
}

