/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import pl.asie.foamfix.FoamFix;
import pl.asie.foamfix.ProxyCommon;
import pl.asie.foamfix.client.FoamFixDynamicItemModels;
import pl.asie.foamfix.client.FoamFixModelRegistryDuplicateWipe;
import pl.asie.foamfix.client.deduplicator.FoamFixModelDeduplicate;
import pl.asie.foamfix.common.WorldNuller;
import pl.asie.foamfix.shared.FoamFixShared;

public class ProxyClient
extends ProxyCommon {
    public static int bakingStage = 0;
    public static final IBakedModel DUMMY_MODEL = new IBakedModel(){
        private final ItemOverrideList itemOverrideList = ItemOverrideList.field_188022_a;

        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            return ImmutableList.of();
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return Minecraft.func_71410_x().func_147117_R().getTextureExtry(TextureMap.field_174945_f.toString());
        }

        public ItemOverrideList func_188617_f() {
            return this.itemOverrideList;
        }
    };

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onModelRegistry(ModelRegistryEvent event) {
        bakingStage = 0;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onModelBake(ModelBakeEvent event) {
        bakingStage = 1;
        FoamFixModelDeduplicate.INSTANCE.onModelBake(event);
    }

    @Override
    public void preInit() {
        super.preInit();
        if (FoamFixShared.isCoremod) {
            try {
                MinecraftForge.EVENT_BUS.register(Class.forName("pl.asie.foamfix.coremod.VertexLighterOverrideHandler").newInstance());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (FoamFixShared.config.clDynamicItemModels) {
            FoamFixDynamicItemModels.register();
        }
        this.updateFasterAnimationFlag();
    }

    @Override
    public void updateFasterAnimationFlag() {
        if (FoamFixShared.config.txFasterAnimation > 0) {
            boolean copyImageSupported;
            ContextCapabilities caps = GLContext.getCapabilities();
            boolean bl = copyImageSupported = caps.OpenGL43 || caps.GL_ARB_copy_image;
            if (!copyImageSupported) {
                if (FoamFixShared.config.txFasterAnimation == 2) {
                    FoamFix.getLogger().warn("Fast animated textures require OpenGL 4.3 or ARB_copy_image extension, which were not detected. Using original slow path.");
                }
                FoamFix.shouldFasterAnimation = false;
            } else {
                String vendor = GL11.glGetString((int)7936);
                if (FoamFixShared.config.txFasterAnimation == 2) {
                    FoamFix.getLogger().info("Using fast animated textures.");
                    FoamFix.shouldFasterAnimation = true;
                } else {
                    FoamFix.shouldFasterAnimation = false;
                }
            }
        }
    }

    @Override
    public void init() {
        super.init();
        if (FoamFixShared.config.gbNotifyNonUnloadedWorlds) {
            WorldNuller.initClient();
        }
        if (FoamFixShared.config.clCleanRedundantModelRegistry) {
            MinecraftForge.EVENT_BUS.register((Object)new FoamFixModelRegistryDuplicateWipe());
        }
    }

    @Override
    public void postInit() {
        super.postInit();
    }

    @Override
    public void refreshResources() {
        FMLClientHandler.instance().scheduleResourcesRefresh(type -> true);
    }
}

