/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.integration;

import com.direwolf20.buildinggadgets.common.blocks.ModBlocks;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.integration.IntegrationHandler;
import com.direwolf20.buildinggadgets.common.items.ModItems;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public interface IPasteRecipeRegistry
extends IntegrationHandler.IIntegratedMod {
    default public IntegrationHandler.Phase getPhase() {
        return IntegrationHandler.Phase.POST_INIT;
    }

    @Override
    default public void initialize(IntegrationHandler.Phase phase) {
        if (this.getPhase() == phase && Config.enablePaste) {
            this.registerAllRecipes();
        }
    }

    default public void registerAllRecipes() {
        this.registerHydrationRecipe(RecipieType.POWDER_TO_BLOCK, new ItemStack((Block)ModBlocks.constructionBlockPowder), new ItemStack((Block)ModBlocks.constructionBlockDense));
        this.registerDeconstructRecipe(RecipieType.BLOCK_TO_CHUNKS, new ItemStack((Block)ModBlocks.constructionBlockDense), new ItemStack((Item)ModItems.constructionChunkDense, 4));
        this.registerDeconstructRecipe(RecipieType.CHUNK_TO_PASTE, new ItemStack((Item)ModItems.constructionChunkDense), new ItemStack((Item)ModItems.constructionPaste));
    }

    default public void registerHydrationRecipe(RecipieType type, ItemStack input, ItemStack output) {
    }

    default public void registerDeconstructRecipe(RecipieType type, ItemStack input, ItemStack output) {
    }

    public static enum RecipieType {
        POWDER_TO_BLOCK,
        BLOCK_TO_CHUNKS,
        CHUNK_TO_PASTE;

    }
}

