/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.structures.big;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;

public class StructureChunk {
    private int[] arrayID = new int[4096];
    private byte[] arrayMeta = new byte[4096];

    public StructureChunk() {
        for (int i = 0; i < this.arrayID.length; ++i) {
            this.arrayID[i] = -1;
        }
    }

    public StructureChunk(NBTTagCompound tag) {
        this.arrayID = tag.func_74759_k("id");
        this.arrayMeta = tag.func_74770_j("meta");
    }

    private int getIndex(int x, int y, int z) {
        return (x << 4 | y) << 4 | z;
    }

    public void setBlock(int blockID, byte blockMeta, int x, int y, int z) {
        int index = this.getIndex(x, y, z);
        this.arrayID[index] = blockID;
        this.arrayMeta[index] = blockMeta;
    }

    public IBlockState getBlockState(int x, int y, int z) {
        int index = this.getIndex(x, y, z);
        if (this.arrayID[index] == -1) {
            return null;
        }
        return Block.func_149729_e((int)this.arrayID[index]).func_176203_a((int)this.arrayMeta[index]);
    }

    public void writeNBT(NBTTagCompound tag) {
        tag.func_74783_a("id", this.arrayID);
        tag.func_74773_a("meta", this.arrayMeta);
    }
}

