/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.client.render;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Vector3;
import codechicken.wirelessredstone.entity.WirelessBolt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;

public class RenderWirelessBolt {
    private static Vector3 getRelativeViewVector(Vector3 pos) {
        Entity renderentity = Minecraft.func_71410_x().func_175606_aa();
        return new Vector3((double)((float)renderentity.field_70165_t) - pos.x, (double)((float)renderentity.field_70163_u + renderentity.func_70047_e()) - pos.y, (double)((float)renderentity.field_70161_v) - pos.z);
    }

    public static void render(float frame, Entity entity) {
        CCRenderState ccrs = CCRenderState.instance();
        GlStateManager.func_179094_E();
        RenderUtils.translateToWorldCoords((Entity)entity, (float)frame);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        ccrs.reset();
        ccrs.brightness = 0xF000F0;
        TextureUtils.changeTexture((String)"wrcbe:textures/lightning_glowstone.png");
        ccrs.startDrawing(7, DefaultVertexFormats.field_181711_k);
        for (WirelessBolt bolt : WirelessBolt.clientboltlist) {
            RenderWirelessBolt.renderBolt(ccrs.getBuffer(), bolt, 0, 0xF000F0);
        }
        ccrs.draw();
        TextureUtils.changeTexture((String)"wrcbe:textures/lightning_redstone.png");
        ccrs.startDrawing(7, DefaultVertexFormats.field_181711_k);
        for (WirelessBolt bolt : WirelessBolt.clientboltlist) {
            RenderWirelessBolt.renderBolt(ccrs.getBuffer(), bolt, 1, 0xF000F0);
        }
        ccrs.draw();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    private static void renderBolt(BufferBuilder buffer, WirelessBolt bolt, int pass, int brightness) {
        float boltage = bolt.particleAge < 0 ? 0.0f : (float)bolt.particleAge / (float)bolt.particleMaxAge;
        float mainalpha = 1.0f;
        mainalpha = pass == 0 ? (1.0f - boltage) * 0.4f : 1.0f - boltage * 0.5f;
        int l1 = brightness >> 16 & 0xFFFF;
        int l2 = brightness & 0xFFFF;
        int expandTime = (int)(bolt.length * 3.0);
        int renderstart = (int)((float)(expandTime / 2 - bolt.particleMaxAge + bolt.particleAge) / (float)(expandTime / 2) * (float)bolt.numsegments0);
        int renderend = (int)((float)(bolt.particleAge + expandTime) / (float)expandTime * (float)bolt.numsegments0);
        for (WirelessBolt.Segment renderSegment : bolt.segments) {
            Vector3 roundend;
            if (renderSegment.segmentno < renderstart || renderSegment.segmentno > renderend) continue;
            Vector3 playervec = RenderWirelessBolt.getRelativeViewVector(renderSegment.startpoint.point).negate();
            double width = (double)0.025f * (playervec.mag() / 5.0 + 1.0) * (double)(1.0f + renderSegment.light) * 0.5;
            Vector3 diff1 = playervec.copy().crossProduct(renderSegment.prevdiff).normalize().multiply(width / (double)renderSegment.sinprev);
            Vector3 diff2 = playervec.copy().crossProduct(renderSegment.nextdiff).normalize().multiply(width / (double)renderSegment.sinnext);
            Vector3 startvec = renderSegment.startpoint.point;
            Vector3 endvec = renderSegment.endpoint.point;
            buffer.func_181662_b(endvec.x - diff2.x, endvec.y - diff2.y, endvec.z - diff2.z).func_187315_a(0.5, 0.0).func_187314_a(l1, l2).func_181666_a(1.0f, 1.0f, 1.0f, mainalpha * renderSegment.light).func_181675_d();
            buffer.func_181662_b(startvec.x - diff1.x, startvec.y - diff1.y, startvec.z - diff1.z).func_187315_a(0.5, 0.0).func_187314_a(l1, l2).func_181666_a(1.0f, 1.0f, 1.0f, mainalpha * renderSegment.light).func_181675_d();
            buffer.func_181662_b(startvec.x + diff1.x, startvec.y + diff1.y, startvec.z + diff1.z).func_187315_a(0.5, 1.0).func_187314_a(l1, l2).func_181666_a(1.0f, 1.0f, 1.0f, mainalpha * renderSegment.light).func_181675_d();
            buffer.func_181662_b(endvec.x + diff2.x, endvec.y + diff2.y, endvec.z + diff2.z).func_187315_a(0.5, 1.0).func_187314_a(l1, l2).func_181666_a(1.0f, 1.0f, 1.0f, mainalpha * renderSegment.light).func_181675_d();
            if (renderSegment.next == null) {
                roundend = renderSegment.endpoint.point.copy().add(renderSegment.diff.copy().normalize().multiply(width));
                buffer.func_181662_b(roundend.x - diff2.x, roundend.y - diff2.y, roundend.z - diff2.z).func_187315_a(0.0, 0.0).func_187314_a(l1, l2).func_181666_a(1.0f, 1.0f, 1.0f, mainalpha * renderSegment.light).func_181675_d();
                buffer.func_181662_b(endvec.x - diff2.x, endvec.y - diff2.y, endvec.z - diff2.z).func_187315_a(0.5, 0.0).func_187314_a(l1, l2).func_181666_a(1.0f, 1.0f, 1.0f, mainalpha * renderSegment.light).func_181675_d();
                buffer.func_181662_b(endvec.x + diff2.x, endvec.y + diff2.y, endvec.z + diff2.z).func_187315_a(0.5, 1.0).func_187314_a(l1, l2).func_181666_a(1.0f, 1.0f, 1.0f, mainalpha * renderSegment.light).func_181675_d();
                buffer.func_181662_b(roundend.x + diff2.x, roundend.y + diff2.y, roundend.z + diff2.z).func_187315_a(0.0, 1.0).func_187314_a(l1, l2).func_181666_a(1.0f, 1.0f, 1.0f, mainalpha * renderSegment.light).func_181675_d();
            }
            if (renderSegment.prev != null) continue;
            roundend = renderSegment.startpoint.point.copy().subtract(renderSegment.diff.copy().normalize().multiply(width));
            buffer.func_181662_b(startvec.x - diff1.x, startvec.y - diff1.y, startvec.z - diff1.z).func_187315_a(0.5, 0.0).func_187314_a(l1, l2).func_181666_a(1.0f, 1.0f, 1.0f, mainalpha * renderSegment.light).func_181675_d();
            buffer.func_181662_b(roundend.x - diff1.x, roundend.y - diff1.y, roundend.z - diff1.z).func_187315_a(0.0, 0.0).func_187314_a(l1, l2).func_181666_a(1.0f, 1.0f, 1.0f, mainalpha * renderSegment.light).func_181675_d();
            buffer.func_181662_b(roundend.x + diff1.x, roundend.y + diff1.y, roundend.z + diff1.z).func_187315_a(0.0, 1.0).func_187314_a(l1, l2).func_181666_a(1.0f, 1.0f, 1.0f, mainalpha * renderSegment.light).func_181675_d();
            buffer.func_181662_b(startvec.x + diff1.x, startvec.y + diff1.y, startvec.z + diff1.z).func_187315_a(0.5, 1.0).func_187314_a(l1, l2).func_181666_a(1.0f, 1.0f, 1.0f, mainalpha * renderSegment.light).func_181675_d();
        }
    }
}

