/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.computer;

import erogenousbeef.bigreactors.common.multiblock.computer.ReactorComputer;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorComputerPort;
import it.zerono.mods.zerocore.lib.block.ModTileEntity;
import it.zerono.mods.zerocore.lib.compat.LuaHelper;
import javax.annotation.Nonnull;
import li.cil.oc.api.API;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public class ReactorComputerOC
extends ReactorComputer
implements Environment {
    @CapabilityInject(value=Environment.class)
    private static Capability<Environment> ENVIRONMENT_CAPABILITY = null;
    private final Node _node = Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent("br_reactor").create();
    private static final String NODE_TAG = "ocNode";

    private ReactorComputerOC(@Nonnull TileEntityReactorComputerPort computerPort) {
        super(computerPort);
    }

    public static boolean isComputerCapability(Capability<?> capability) {
        return null != ENVIRONMENT_CAPABILITY && ENVIRONMENT_CAPABILITY == capability;
    }

    public static ReactorComputer create(TileEntityReactorComputerPort tileEntity) {
        return new ReactorComputerOC(tileEntity);
    }

    @Override
    public void onAttachedToController() {
        if (null != this._node && this._node.network() == null) {
            API.network.joinOrCreateNetwork((TileEntity)this.getComputerPort());
            this.getComputerPort().func_70296_d();
        }
    }

    @Override
    public void onDetachedFromController() {
        if (null != this._node) {
            this._node.remove();
        }
    }

    @Override
    public void syncDataFrom(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        if (null != this.node() && data.func_74764_b(NODE_TAG)) {
            this.node().load(data.func_74775_l(NODE_TAG));
        }
    }

    @Override
    public void syncDataTo(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        if (this.node() != null) {
            if (this.node().address() == null) {
                Network.joinNewNetwork((Node)this.node());
                NBTTagCompound nodeTag = new NBTTagCompound();
                this.node().save(nodeTag);
                data.func_74782_a(NODE_TAG, (NBTBase)nodeTag);
                this.node().remove();
            } else {
                NBTTagCompound nodeTag = new NBTTagCompound();
                this.node().save(nodeTag);
                data.func_74782_a(NODE_TAG, (NBTBase)nodeTag);
            }
        }
    }

    @Callback(direct=true)
    public Object[] getMultiblockAssembled(Context context, Arguments arguments) throws Exception {
        return new Object[]{this.getMultiblockAssembled()};
    }

    @Callback(direct=true)
    public Object[] getConnected(Context context, Arguments arguments) throws Exception {
        return new Object[]{this.getConnected()};
    }

    @Callback(direct=true)
    public Object[] getActive(Context context, Arguments arguments) throws Exception {
        return new Object[]{this.getActive()};
    }

    @Callback(direct=true)
    public Object[] getFuelTemperature(Context context, Arguments arguments) throws Exception {
        return new Object[]{Float.valueOf(this.getFuelTemperature())};
    }

    @Callback(direct=true)
    public Object[] getCasingTemperature(Context context, Arguments arguments) throws Exception {
        return new Object[]{Float.valueOf(this.getCasingTemperature())};
    }

    @Callback(direct=true)
    public Object[] getEnergyStored(Context context, Arguments arguments) throws Exception {
        return new Object[]{this.getEnergyStored()};
    }

    @Callback(direct=true)
    public Object[] getFuelAmount(Context context, Arguments arguments) throws Exception {
        return new Object[]{this.getFuelAmount()};
    }

    @Callback(direct=true)
    public Object[] getWasteAmount(Context context, Arguments arguments) throws Exception {
        return new Object[]{this.getWasteAmount()};
    }

    @Callback(direct=true)
    public Object[] getFuelAmountMax(Context context, Arguments arguments) throws Exception {
        return new Object[]{this.getFuelAmountMax()};
    }

    @Callback(direct=true)
    public Object[] getControlRodName(Context context, Arguments arguments) throws Exception {
        LuaHelper.validateArgsCount((Arguments)arguments, (int)1);
        return new Object[]{this.getControlRodName(LuaHelper.getIntFromArgs((Arguments)arguments, (int)0))};
    }

    @Callback(direct=true)
    public Object[] getNumberOfControlRods(Context context, Arguments arguments) throws Exception {
        return new Object[]{this.getNumberOfControlRods()};
    }

    @Callback(direct=true)
    public Object[] getControlRodLevel(Context context, Arguments arguments) throws Exception {
        LuaHelper.validateArgsCount((Arguments)arguments, (int)1);
        return new Object[]{this.getControlRodLevel(LuaHelper.getIntFromArgs((Arguments)arguments, (int)0))};
    }

    @Callback(direct=true)
    public Object[] getEnergyProducedLastTick(Context context, Arguments arguments) throws Exception {
        return new Object[]{Float.valueOf(this.getEnergyProducedLastTick())};
    }

    @Callback(direct=true)
    public Object[] getHotFluidProducedLastTick(Context context, Arguments arguments) throws Exception {
        return new Object[]{Float.valueOf(this.getHotFluidProducedLastTick())};
    }

    @Callback(direct=true)
    public Object[] getCoolantAmount(Context context, Arguments arguments) throws Exception {
        return new Object[]{this.getCoolantAmount()};
    }

    @Callback(direct=true)
    public Object[] getCoolantAmountMax(Context context, Arguments arguments) throws Exception {
        return new Object[]{this.getCoolantAmountMax()};
    }

    @Callback(direct=true)
    public Object[] getCoolantType(Context context, Arguments arguments) throws Exception {
        return new Object[]{this.getCoolantType()};
    }

    @Callback(direct=true)
    public Object[] getHotFluidAmount(Context context, Arguments arguments) throws Exception {
        return new Object[]{this.getHotFluidAmount()};
    }

    @Callback(direct=true)
    public Object[] getHotFluidAmountMax(Context context, Arguments arguments) throws Exception {
        return new Object[]{this.getHotFluidAmountMax()};
    }

    @Callback(direct=true)
    public Object[] getHotFluidType(Context context, Arguments arguments) throws Exception {
        return new Object[]{this.getHotFluidType()};
    }

    @Callback(direct=true)
    public Object[] getFuelReactivity(Context context, Arguments arguments) throws Exception {
        return new Object[]{Float.valueOf(this.getFuelReactivity())};
    }

    @Callback(direct=true)
    public Object[] getFuelConsumedLastTick(Context context, Arguments arguments) throws Exception {
        return new Object[]{Float.valueOf(this.getFuelConsumedLastTick())};
    }

    @Callback(direct=true)
    public Object[] getMinimumCoordinate(Context context, Arguments arguments) throws Exception {
        BlockPos coords = this.getMinimumCoordinate();
        return new Object[]{coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p()};
    }

    @Callback(direct=true)
    public Object[] getMaximumCoordinate(Context context, Arguments arguments) throws Exception {
        BlockPos coords = this.getMaximumCoordinate();
        return new Object[]{coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p()};
    }

    @Callback(direct=true)
    public Object[] getControlRodLocation(Context context, Arguments arguments) throws Exception {
        LuaHelper.validateArgsCount((Arguments)arguments, (int)1);
        return new Object[]{this.getControlRodLocation(LuaHelper.getIntFromArgs((Arguments)arguments, (int)0))};
    }

    @Callback(direct=true)
    public Object[] isActivelyCooled(Context context, Arguments arguments) throws Exception {
        return new Object[]{this.isActivelyCooled()};
    }

    @Callback(direct=true)
    public Object[] setActive(Context context, Arguments arguments) throws Exception {
        LuaHelper.validateArgsCount((Arguments)arguments, (int)1);
        this.setActive(LuaHelper.getBooleanFromArgs((Arguments)arguments, (int)0));
        return null;
    }

    @Callback(direct=true)
    public Object[] setControlRodLevel(Context context, Arguments arguments) throws Exception {
        LuaHelper.validateArgsCount((Arguments)arguments, (int)2);
        this.setControlRodLevel(LuaHelper.getIntFromArgs((Arguments)arguments, (int)0), LuaHelper.getIntFromArgs((Arguments)arguments, (int)1, (int)0, (int)100));
        return null;
    }

    @Callback(direct=true)
    public Object[] setAllControlRodLevels(Context context, Arguments arguments) throws Exception {
        LuaHelper.validateArgsCount((Arguments)arguments, (int)1);
        this.setAllControlRodLevels(LuaHelper.getIntFromArgs((Arguments)arguments, (int)0, (int)0, (int)100));
        return null;
    }

    @Callback(direct=true)
    public Object[] setControlRodName(Context context, Arguments arguments) throws Exception {
        LuaHelper.validateArgsCount((Arguments)arguments, (int)2);
        this.setControlRodName(LuaHelper.getIntFromArgs((Arguments)arguments, (int)0), LuaHelper.getStringFromArgs((Arguments)arguments, (int)1));
        return null;
    }

    @Callback(direct=true)
    public Object[] doEjectWaste(Context context, Arguments arguments) throws Exception {
        this.doEjectWaste();
        return null;
    }

    @Callback(direct=true)
    public Object[] doEjectFuel(Context context, Arguments arguments) throws Exception {
        this.doEjectFuel();
        return null;
    }

    @Callback(direct=true)
    public Object[] getEnergyCapacity(Context context, Arguments arguments) throws Exception {
        return new Object[]{this.getEnergyCapacity()};
    }

    public Node node() {
        return this._node;
    }

    public void onConnect(Node node) {
    }

    public void onDisconnect(Node node) {
    }

    public void onMessage(Message message) {
    }
}

