/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.asm;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class IEClassTransformer
implements IClassTransformer {
    private static Map<String, MethodTransformer[]> transformerMap = Maps.newHashMap();

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass != null && transformerMap.containsKey(transformedName)) {
            MethodTransformer[] transformers = transformerMap.get(transformedName);
            ClassReader reader = new ClassReader(basicClass);
            ClassNode node = new ClassNode();
            reader.accept((ClassVisitor)node, 0);
            for (MethodNode method : node.methods) {
                for (MethodTransformer methodTransformer : transformers) {
                    if (!methodTransformer.functionName.equals(method.name) && !methodTransformer.srgName.equals(method.name) || !methodTransformer.functionDesc.equals(method.desc)) continue;
                    methodTransformer.function.accept(method);
                }
            }
            ClassWriter writer = new ClassWriter(3);
            node.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return basicClass;
    }

    static {
        transformerMap.put("net.minecraft.client.model.ModelBiped", new MethodTransformer[]{new MethodTransformer("setRotationAngles", "func_78087_a", "(FFFFFFLnet/minecraft/entity/Entity;)V", methodNode -> {
            for (AbstractInsnNode anode : methodNode.instructions) {
                if (anode.getOpcode() != 177) continue;
                InsnList newInstructions = new InsnList();
                newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 7));
                newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, "blusunrize/immersiveengineering/client/ClientUtils", "handleBipedRotations", "(Lnet/minecraft/client/model/ModelBiped;Lnet/minecraft/entity/Entity;)V", false));
                methodNode.instructions.insertBefore(anode, newInstructions);
            }
        })});
        transformerMap.put("net.minecraft.entity.Entity", new MethodTransformer[]{new MethodTransformer("doBlockCollisions", "func_145775_I", "()V", m -> {
            for (AbstractInsnNode anode : m.instructions) {
                if (anode.getOpcode() != 182) continue;
                MethodInsnNode n = (MethodInsnNode)anode;
                if (!n.name.equals("onEntityCollision") && !n.name.equals("func_180634_a")) continue;
                InsnList newInstructions = new InsnList();
                newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 4));
                newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, "blusunrize/immersiveengineering/api/energy/wires/ImmersiveNetHandler", "handleEntityCollision", "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/Entity;)V", false));
                m.instructions.insert((AbstractInsnNode)n, newInstructions);
            }
        })});
    }

    private static class MethodTransformer {
        final String functionName;
        final String srgName;
        final String functionDesc;
        final Consumer<MethodNode> function;

        private MethodTransformer(String funcName, String srgName, String funcDesc, Consumer<MethodNode> function) {
            this.functionName = funcName;
            this.srgName = srgName;
            this.functionDesc = funcDesc;
            this.function = function;
        }
    }
}

