/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.tileentity;

import gcewing.sg.BaseBlockUtils;
import gcewing.sg.BaseConfiguration;
import gcewing.sg.BaseTileInventory;
import gcewing.sg.BaseUtils;
import gcewing.sg.SGCraft;
import gcewing.sg.Trans3;
import gcewing.sg.Vector3;
import gcewing.sg.block.DHDBlock;
import gcewing.sg.interfaces.ISGEnergySource;
import gcewing.sg.tileentity.SGBaseTE;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class DHDTE
extends BaseTileInventory
implements ISGEnergySource {
    public static boolean debugLink = false;
    public static int linkRangeX = 5;
    public static int linkRangeY = 1;
    public static int linkRangeZ = 6;
    public static AxisAlignedBB bounds;
    public static final int firstFuelSlot = 0;
    public static final int numFuelSlots = 4;
    private static final int numSlots = 4;
    public static double cfgMaxEnergyBuffer;
    public boolean isLinkedToStargate;
    public BlockPos linkedPos = new BlockPos(0, 0, 0);
    public String enteredAddress = "";
    public IInventory inventory = new InventoryBasic("DHD", false, 4);
    public double maxEnergyBuffer = 2500.0;
    public double energyInBuffer = 0.0;

    public DHDTE() {
    }

    public DHDTE(double maxEnergyBuffer) {
        this.maxEnergyBuffer = maxEnergyBuffer;
    }

    public static void configure(BaseConfiguration cfg) {
        linkRangeX = cfg.getInteger("dhd", "linkRangeX", linkRangeX);
        linkRangeY = cfg.getInteger("dhd", "linkRangeY", linkRangeY);
        linkRangeZ = cfg.getInteger("dhd", "linkRangeZ", linkRangeZ);
        cfgMaxEnergyBuffer = cfg.getDouble("dhd", "maxEnergyBuffer", cfgMaxEnergyBuffer);
    }

    public static DHDTE at(IBlockAccess world, BlockPos pos) {
        TileEntity te = BaseBlockUtils.getWorldTileEntity(world, pos);
        return te instanceof DHDTE ? (DHDTE)te : null;
    }

    public static DHDTE at(IBlockAccess world, NBTTagCompound nbt) {
        BlockPos pos = new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
        return DHDTE.at(world, pos);
    }

    public void enterSymbol(EntityPlayer player, char symbol) {
        SGBaseTE gate = this.getLinkedStargateTE();
        if (gate != null && this.enteredAddress.length() < gate.getNumChevrons()) {
            this.enteredAddress = this.enteredAddress + symbol;
            if (gate.chevronsLockOnDial) {
                boolean last = this.enteredAddress.length() == gate.getNumChevrons();
                gate.finishDiallingSymbol(Character.toString(symbol), true, false, last);
                gate.dialledAddress = this.enteredAddress;
                gate.numEngagedChevrons = this.enteredAddress.length();
                gate.markChanged();
            }
        }
    }

    public void unsetSymbol(EntityPlayer player) {
        SGBaseTE gate = this.getLinkedStargateTE();
        if (gate != null && !this.enteredAddress.isEmpty()) {
            char symbol = this.enteredAddress.charAt(this.enteredAddress.length() - 1);
            this.enteredAddress = this.enteredAddress.substring(0, this.enteredAddress.length() - 1);
            if (gate.chevronsLockOnDial) {
                gate.unsetSymbol(symbol);
                gate.dialledAddress = this.enteredAddress;
                gate.numEngagedChevrons = this.enteredAddress.length();
                gate.markChanged();
            }
        }
    }

    public void clearAddress() {
        this.enteredAddress = "";
        this.markChanged();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return bounds.func_72321_a((double)this.getX() + 0.5, (double)this.getY(), (double)this.getZ() + 0.5);
    }

    public double func_145833_n() {
        return 32768.0;
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    public DHDBlock getBlock() {
        return (DHDBlock)this.func_145838_q();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isLinkedToStargate = nbt.func_74767_n("isLinkedToStargate");
        this.energyInBuffer = nbt.func_74769_h("energyInBuffer");
        int x = nbt.func_74762_e("linkedX");
        int y = nbt.func_74762_e("linkedY");
        int z = nbt.func_74762_e("linkedZ");
        this.linkedPos = new BlockPos(x, y, z);
        this.enteredAddress = nbt.func_74779_i("enteredAddress");
        this.maxEnergyBuffer = !nbt.func_74764_b("bufferSize") || SGCraft.forceDHDCfgUpdate ? cfgMaxEnergyBuffer : nbt.func_74769_h("bufferSize");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("isLinkedToStargate", this.isLinkedToStargate);
        nbt.func_74780_a("energyInBuffer", this.energyInBuffer);
        nbt.func_74768_a("linkedX", this.linkedPos.func_177958_n());
        nbt.func_74768_a("linkedY", this.linkedPos.func_177956_o());
        nbt.func_74768_a("linkedZ", this.linkedPos.func_177952_p());
        nbt.func_74778_a("enteredAddress", this.enteredAddress);
        nbt.func_74780_a("bufferSize", this.maxEnergyBuffer);
        return nbt;
    }

    public SGBaseTE getLinkedStargateTE() {
        TileEntity gte;
        if (this.isLinkedToStargate && (gte = BaseBlockUtils.getWorldTileEntity((IBlockAccess)this.field_145850_b, this.linkedPos)) instanceof SGBaseTE) {
            return (SGBaseTE)gte;
        }
        return null;
    }

    public void checkForLink() {
        if (debugLink) {
            System.out.printf("DHDTE.checkForLink at %s: isLinkedToStargate = %s\n", this.field_174879_c, this.isLinkedToStargate);
        }
        if (!this.isLinkedToStargate) {
            Trans3 t = this.localToGlobalTransformation();
            for (int i = -linkRangeX; i <= linkRangeX; ++i) {
                for (int j = -linkRangeY; j <= linkRangeY; ++j) {
                    for (int k = -linkRangeZ; k <= linkRangeZ; ++k) {
                        TileEntity te;
                        Vector3 p = t.p(i, j, -k);
                        BlockPos bp = new BlockPos(p.floorX(), p.floorY(), p.floorZ());
                        if (debugLink) {
                            System.out.printf("DHDTE.checkForLink: probing %s\n", bp);
                        }
                        if (!((te = this.field_145850_b.func_175625_s(bp)) instanceof SGBaseTE)) continue;
                        if (debugLink) {
                            System.out.printf("DHDTE.checkForLink: Found stargate at %s\n", te.func_174877_v());
                        }
                        if (!this.linkToStargate((SGBaseTE)te)) continue;
                        return;
                    }
                }
            }
        }
    }

    public boolean linkToStargate(SGBaseTE gte) {
        if (!this.isLinkedToStargate && !gte.isLinkedToController && gte.isMerged) {
            if (debugLink) {
                System.out.printf("DHDTE.linkToStargate: Linking controller at %s with stargate at %s\n", this.field_174879_c, gte.func_174877_v());
            }
            this.linkedPos = gte.func_174877_v();
            this.isLinkedToStargate = true;
            this.markChanged();
            gte.linkedPos = this.field_174879_c;
            gte.isLinkedToController = true;
            gte.markChanged();
            return true;
        }
        return false;
    }

    public void clearLinkToStargate() {
        if (debugLink) {
            System.out.printf("DHDTE: Unlinking controller at %s from stargate\n", this.field_174879_c);
        }
        this.isLinkedToStargate = false;
        this.markChanged();
    }

    @Override
    public double availableEnergy() {
        double energy = this.energyInBuffer;
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = this.fuelStackInSlot(i);
            if (stack == null) continue;
            SGBaseTE baseTe = this.getLinkedStargateTE();
            energy += (double)stack.func_190916_E() * baseTe.energyPerFuelItem;
        }
        return energy;
    }

    @Override
    public double drawEnergyDouble(double amount) {
        double energyDrawn = 0.0;
        while (energyDrawn < amount && (this.energyInBuffer != 0.0 || this.useFuelItem())) {
            double e = BaseUtils.min(amount, this.energyInBuffer);
            energyDrawn += e;
            this.energyInBuffer -= e;
        }
        if (SGBaseTE.debugEnergyUse) {
            System.out.printf("DHDTE.drawEnergyDouble: %s; supplied: %s; buffered: %s\n", amount, energyDrawn, this.energyInBuffer);
        }
        this.markChanged();
        return energyDrawn;
    }

    @Override
    public double totalAvailableEnergy() {
        return this.energyInBuffer;
    }

    boolean useFuelItem() {
        for (int i = 3; i >= 0; --i) {
            ItemStack stack = this.fuelStackInSlot(i);
            if (stack == null) continue;
            this.func_70298_a(i, 1);
            SGBaseTE baseTe = this.getLinkedStargateTE();
            this.energyInBuffer += baseTe.energyPerFuelItem;
            return true;
        }
        return false;
    }

    ItemStack fuelStackInSlot(int i) {
        ItemStack stack = this.func_70301_a(0 + i);
        return DHDTE.isValidFuelItem(stack) ? stack : null;
    }

    public static boolean isValidFuelItem(ItemStack stack) {
        return stack != null && stack.func_77973_b() == SGCraft.naquadah && stack.func_190916_E() > 0;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return DHDTE.isValidFuelItem(stack);
    }

    static {
        cfgMaxEnergyBuffer = 2500.0;
    }
}

