/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.generator;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.world.World;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.yaml.YAMLConfigurationLoader;
import org.yaml.snakeyaml.DumperOptions;

public final class GeneratorAddressRegistry {
    private static final Map<String, Set<String>> addresses = new HashMap<String, Set<String>>();
    private static final String WORLDS_NODE = "worlds";

    public static ConfigurationNode createRootNode(Path path) throws IOException {
        YAMLConfigurationLoader loader = ((YAMLConfigurationLoader.Builder)YAMLConfigurationLoader.builder().setPath(path)).setFlowStyle(DumperOptions.FlowStyle.BLOCK).build();
        if (Files.notExists(path, new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.createFile(path, new FileAttribute[0]);
            ConfigurationNode node = loader.createEmptyNode(ConfigurationOptions.defaults());
            GeneratorAddressRegistry.populateTemplate(node);
            loader.save(node);
        }
        return loader.load(ConfigurationOptions.defaults());
    }

    public static void populateAddresses(ConfigurationNode root) {
        Preconditions.checkNotNull((Object)root);
        addresses.clear();
        ConfigurationNode worldsRoot = root.getNode(WORLDS_NODE);
        for (Map.Entry<Object, ? extends ConfigurationNode> worldEntry : worldsRoot.getChildrenMap().entrySet()) {
            String world = worldEntry.getKey().toString().toLowerCase();
            if (world.isEmpty()) continue;
            try {
                List worldAddresses = worldEntry.getValue().getList(TypeToken.of(String.class));
                addresses.put(world, Sets.newHashSet(worldAddresses));
            }
            catch (ObjectMappingException e) {
                e.printStackTrace();
            }
        }
    }

    public static void addAddress(World world, String address) {
        Preconditions.checkNotNull((Object)world);
        Preconditions.checkNotNull((Object)address);
        addresses.computeIfAbsent(world.func_72912_H().func_76065_j().toLowerCase(), k -> new HashSet()).add(address.toUpperCase());
        GeneratorAddressRegistry.writeAddresses();
    }

    public static boolean removeAddress(World world, String homeAddress) {
        Preconditions.checkNotNull((Object)world);
        Set worldAddresses = addresses.getOrDefault(world.func_72912_H().func_76065_j().toLowerCase(), new HashSet());
        boolean removed = worldAddresses.removeIf(s -> s.equalsIgnoreCase(homeAddress));
        GeneratorAddressRegistry.writeAddresses();
        return removed;
    }

    public static void writeAddresses() {
        Path path = Paths.get(".", "config", "SGCraft", "generator.yml");
        try {
            ConfigurationNode rootNode = GeneratorAddressRegistry.createRootNode(path);
            ConfigurationNode worldsNode = rootNode.getNode(WORLDS_NODE);
            if (!addresses.isEmpty()) {
                addresses.forEach((key, value) -> worldsNode.getNode(key).setValue(Lists.newArrayList((Iterable)value)));
            } else {
                GeneratorAddressRegistry.populateTemplate(rootNode);
            }
            YAMLConfigurationLoader loader = ((YAMLConfigurationLoader.Builder)YAMLConfigurationLoader.builder().setPath(path)).setFlowStyle(DumperOptions.FlowStyle.BLOCK).build();
            if (Files.notExists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.createFile(path, new FileAttribute[0]);
            }
            loader.save(rootNode);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String randomAddress(World world, String homeAddress, Random random) {
        Preconditions.checkNotNull((Object)world);
        Preconditions.checkNotNull((Object)random);
        Set worldAddressesAll = addresses.getOrDefault(world.func_72912_H().func_76065_j().toLowerCase(), new HashSet());
        HashSet<String> worldAddresses = new HashSet<String>(worldAddressesAll);
        boolean removed = worldAddresses.removeIf(s -> s.equalsIgnoreCase(homeAddress));
        if (worldAddresses.isEmpty()) {
            return null;
        }
        int max = worldAddresses.size();
        int rIndex = random.nextInt(max);
        Iterator iter = worldAddresses.iterator();
        int index = 0;
        while (iter.hasNext()) {
            String address = (String)iter.next();
            if (rIndex == index) {
                return Optional.of(address).get().toUpperCase();
            }
            ++index;
        }
        return null;
    }

    private static void populateTemplate(ConfigurationNode node) {
    }
}

