/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.features.ic2;

import gcewing.sg.BaseUtils;
import gcewing.sg.SGCraft;
import gcewing.sg.tileentity.PowerTE;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class IC2PowerTE
extends PowerTE
implements IEnergySink,
ITickable {
    private boolean debugLoad = false;
    private boolean debugInput = false;
    private int maxSafeInput = SGCraft.Ic2SafeInput;
    private int powerTier = SGCraft.Ic2PowerTETier;
    private int update = 0;
    private boolean loaded = false;

    public IC2PowerTE() {
        super(SGCraft.Ic2MaxEnergyBuffer, SGCraft.Ic2euPerSGEnergyUnit);
    }

    @Override
    public void readContentsFromNBT(NBTTagCompound nbttagcompound) {
        super.readContentsFromNBT(nbttagcompound);
        if (!nbttagcompound.func_74764_b("input") || SGCraft.forceIC2CfgUpdate) {
            this.maxSafeInput = SGCraft.Ic2SafeInput;
            this.powerTier = SGCraft.Ic2PowerTETier;
            this.energyMax = SGCraft.Ic2MaxEnergyBuffer;
            this.energyPerSGEnergyUnit = SGCraft.Ic2euPerSGEnergyUnit;
        } else {
            this.maxSafeInput = nbttagcompound.func_74762_e("input");
            this.powerTier = nbttagcompound.func_74762_e("tier");
        }
    }

    @Override
    public void writeContentsToNBT(NBTTagCompound nbttagcompound) {
        super.writeContentsToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("input", this.maxSafeInput);
        nbttagcompound.func_74768_a("tier", this.powerTier);
    }

    @Override
    public String getScreenTitle() {
        return "IC2 SGPU";
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && !this.loaded) {
            if (this.debugLoad) {
                System.out.printf("SGCraft: IC2PowerTE: Adding to energy network\n", new Object[0]);
            }
            this.loaded = true;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
        }
    }

    @Override
    public String getUnitName() {
        return "EU";
    }

    @Override
    public void func_145843_s() {
        this.unload();
        super.func_145843_s();
    }

    public void onChunkUnload() {
        this.unload();
        super.onChunkUnload();
    }

    public static IC2PowerTE at(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof IC2PowerTE ? (IC2PowerTE)te : null;
    }

    void unload() {
        if (!this.field_145850_b.field_72995_K && this.loaded) {
            if (this.debugLoad) {
                System.out.printf("SGCraft: IC2PowerTE: Removing from energy network\n", new Object[0]);
            }
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.loaded = false;
        }
    }

    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing direction) {
        return true;
    }

    public double getDemandedEnergy() {
        double eu = BaseUtils.min(this.energyMax - this.energyBuffer, (double)this.maxSafeInput);
        if (this.debugInput) {
            System.out.printf("SGCraft: IC2PowerTE: Demanding %s EU\n", eu);
        }
        return eu;
    }

    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        this.energyBuffer += amount;
        if (this.update++ > 10) {
            this.markChanged();
            this.update = 0;
        }
        if (this.debugInput) {
            System.out.printf("SGCraft: IC2PowerTE: Injected %s EU giving %s\n", amount, this.energyBuffer);
        }
        return 0.0;
    }

    public int getSinkTier() {
        return this.powerTier;
    }

    @Override
    public double totalAvailableEnergy() {
        return this.energyBuffer;
    }
}

