/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import stevekung.mods.moreplanets.tileentity.TileEntityAlienChest;
import stevekung.mods.moreplanets.utils.blocks.BlockChestMP;
import stevekung.mods.moreplanets.utils.itemblocks.IItemRarity;
import stevekung.mods.moreplanets.utils.tileentity.TileEntityChestMP;
import stevekung.mods.stevekunglib.utils.ColorUtils;
import stevekung.mods.stevekunglib.utils.LangUtils;

public class BlockAlienChest
extends BlockChestMP
implements IItemRarity {
    public BlockAlienChest(String name) {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149663_c(name);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityAlienChest) {
            tile.func_145836_u();
        }
    }

    @Override
    protected TileEntityChestMP getChestTile() {
        return new TileEntityAlienChest();
    }

    @Override
    public ColorUtils.RGB getRarity() {
        return ColorUtils.stringToRGB((String)"178, 109, 237");
    }

    @Override
    protected ILockableContainer getLockableContainer(World world, BlockPos pos, boolean allowBlocking) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileEntityAlienChest)) {
            return null;
        }
        TileEntityAlienChest ilockablecontainer = (TileEntityAlienChest)tile;
        if (!allowBlocking && this.isBlocked(world, pos)) {
            return null;
        }
        for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.func_177972_a(facing);
            Block block = world.func_180495_p(blockpos).func_177230_c();
            if (block != this) continue;
            if (!allowBlocking && this.isBlocked(world, blockpos)) {
                return null;
            }
            TileEntity tileentity1 = world.func_175625_s(blockpos);
            if (!(tileentity1 instanceof TileEntityAlienChest)) continue;
            if (facing != EnumFacing.WEST && facing != EnumFacing.NORTH) {
                ilockablecontainer = new InventoryLargeChest(LangUtils.translate((String)"container.chestDouble"), (ILockableContainer)ilockablecontainer, (ILockableContainer)((TileEntityAlienChest)tileentity1));
                continue;
            }
            ilockablecontainer = new InventoryLargeChest(LangUtils.translate((String)"container.chestDouble"), (ILockableContainer)((TileEntityAlienChest)tileentity1), (ILockableContainer)ilockablecontainer);
        }
        return ilockablecontainer;
    }
}

