/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.capability.provider;

import io.github.phantamanta44.libnine.capability.provider.CapabilityBroker;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public class CapabilityBrokerLazy
extends CapabilityBroker {
    private final Function<Capability<?>, Object> factory;
    private final Set<Capability<?>> closedSet;

    public CapabilityBrokerLazy(Function<Capability<?>, Object> factory) {
        this.factory = factory;
        this.closedSet = new HashSet();
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return super.hasCapability(capability, facing) || !this.closedSet.contains(capability) && this.tryLateResolve(capability) != null;
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        T aspect = super.getCapability(capability, facing);
        return (T)(aspect != null ? aspect : (this.closedSet.contains(capability) ? null : this.tryLateResolve(capability)));
    }

    @Nullable
    private <T> T tryLateResolve(Capability<T> capability) {
        this.closedSet.add(capability);
        Object aspect = this.factory.apply(capability);
        if (aspect != null) {
            this.with(capability, aspect);
        }
        return (T)aspect;
    }
}

