/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpc;

import me.hypherionmc.simplerpc.ClientEventHandler;
import me.hypherionmc.simplerpc.network.ConfigPacket;
import me.hypherionmc.simplerpc.network.NetworkHandler;
import me.hypherionmc.simplerpclib.configuration.ConfigEngine;
import me.hypherionmc.simplerpclib.configuration.ServerConfig;
import me.hypherionmc.simplerpclib.util.FileWatcherService;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="simple-rpc", name="Simple RPC", version="@VERSION@", clientSideOnly=false, acceptableRemoteVersions="*", acceptedMinecraftVersions="1.12.2", dependencies="required-after:forge;before:pixelmon")
public class SimpleRPC {
    @Mod.Instance(value="simple-rpc")
    public static SimpleRPC INSTANCE;
    private ServerConfig serverConfig;
    private FileWatcherService serverConfigWatcher;

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            ClientEventHandler clientEventHandler = new ClientEventHandler();
            MinecraftForge.EVENT_BUS.register((Object)clientEventHandler);
            clientEventHandler.preinit(event);
        } else {
            this.serverConfig = ConfigEngine.loadServerConfig(".");
            this.serverConfigWatcher = new FileWatcherService("./config/simple-rpc-server.toml", () -> {
                this.serverConfig = ConfigEngine.loadServerConfig(".");
                ConfigPacket packet = new ConfigPacket(this.serverConfig);
                NetworkHandler.sendTo(packet);
            });
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
        NetworkHandler.registerPackets();
    }

    @SubscribeEvent
    public void onServerStarted(TickEvent.ServerTickEvent event) {
        if (!(event.phase != TickEvent.Phase.END || event.side != Side.SERVER || this.serverConfigWatcher == null || this.serverConfigWatcher.getThread() != null && this.serverConfigWatcher.getThread().isAlive())) {
            this.serverConfigWatcher.start();
        }
    }

    @SubscribeEvent
    public void onEntityJoin(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP && FMLCommonHandler.instance().getEffectiveSide().isServer() && this.serverConfig != null && this.serverConfig.enabled) {
            ConfigPacket packet = new ConfigPacket(this.serverConfig);
            NetworkHandler.sendTo((EntityPlayerMP)event.getEntity(), packet);
        }
    }
}

