/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.tileentity;

import lumien.randomthings.RandomThings;
import lumien.randomthings.recipes.imbuing.ImbuingRecipeHandler;
import lumien.randomthings.tileentity.TileEntityBase;
import lumien.randomthings.util.InventoryUtil;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.logging.log4j.Level;

public class TileEntityImbuingStation
extends TileEntityBase
implements ITickable {
    public int imbuingProgress;
    ItemStack currentOutput = ItemStack.field_190927_a;
    public static final int IMBUING_LENGTH = 200;

    public TileEntityImbuingStation() {
        this.setItemHandler(5);
        this.setItemHandlerPublic(new int[]{0, 1, 2, 3}, new int[]{4});
    }

    @Override
    public void writeDataToNBT(NBTTagCompound nbt, boolean sync) {
        nbt.func_74768_a("imbuingProgress", this.imbuingProgress);
        if (!this.currentOutput.func_190926_b()) {
            NBTTagCompound outputCompound = new NBTTagCompound();
            this.currentOutput.func_77955_b(outputCompound);
            nbt.func_74782_a("output", (NBTBase)outputCompound);
        }
    }

    @Override
    public void readDataFromNBT(NBTTagCompound nbt, boolean sync) {
        this.imbuingProgress = nbt.func_74762_e("imbuingProgress");
        boolean inventoryThere = false;
        for (int slot = 0; slot < this.getItemHandler().getSlots(); ++slot) {
            if (!nbt.func_74764_b("slot" + slot)) continue;
            inventoryThere = true;
            break;
        }
        if (inventoryThere) {
            InventoryBasic inventory = new InventoryBasic("", false, this.getItemHandler().getSlots());
            InventoryUtil.readInventoryFromCompound(nbt, (IInventory)inventory);
            for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
                ((ItemStackHandler)this.getItemHandler()).setStackInSlot(slot, inventory.func_70301_a(slot));
            }
            RandomThings.instance.logger.log(Level.DEBUG, "Switching Imbuing Station to Item Handler...");
        }
        if (nbt.func_74764_b("output")) {
            this.currentOutput = new ItemStack(nbt.func_74775_l("output"));
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack validOutput = ImbuingRecipeHandler.getRecipeOutput(this.getItemHandler());
            if (!ItemStack.func_77989_b((ItemStack)validOutput, (ItemStack)this.currentOutput) && this.canHandleOutput(validOutput)) {
                this.imbuingProgress = 0;
                this.currentOutput = validOutput;
            }
            if (!this.currentOutput.func_190926_b()) {
                ++this.imbuingProgress;
                if (this.imbuingProgress >= 200) {
                    this.imbuingProgress = 0;
                    this.imbue();
                }
            } else {
                this.imbuingProgress = 0;
            }
        }
    }

    private boolean canHandleOutput(ItemStack validOutput) {
        ItemStack requiredOutput;
        if (validOutput.func_190926_b() || this.getItemHandler().getStackInSlot(4).func_190926_b()) {
            return true;
        }
        ItemStack currentInOutput = this.getItemHandler().getStackInSlot(4);
        if (!ItemStack.func_179545_c((ItemStack)currentInOutput, (ItemStack)(requiredOutput = validOutput)) || !ItemStack.func_77970_a((ItemStack)currentInOutput, (ItemStack)requiredOutput)) {
            return false;
        }
        return currentInOutput.func_190916_E() + requiredOutput.func_190916_E() <= currentInOutput.func_77976_d();
    }

    private void imbue() {
        this.getItemHandler().insertItem(4, this.currentOutput.func_77946_l(), false);
        for (int slot = 0; slot < this.getItemHandler().getSlots() - 1; ++slot) {
            this.getItemHandler().extractItem(slot, 1, false);
        }
    }
}

