/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.handler.festival;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import lumien.randomthings.handler.festival.Festival;
import lumien.randomthings.network.MessageUtil;
import lumien.randomthings.util.ReflectionUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChat;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.village.Village;
import net.minecraft.village.VillageDoorInfo;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class FestivalHandler
extends WorldSavedData {
    static final String ID = "RTFestivalHandler";
    List<Festival> currentFestivals = new ArrayList<Festival>();
    static Random rng = new Random();

    public FestivalHandler(String id) {
        super(id);
    }

    public FestivalHandler() {
        this(ID);
    }

    public int addFestival(EntityVillager villager) {
        List doorInfos;
        Village v = ReflectionUtil.getVillage(villager);
        if (v != null && (doorInfos = v.func_75558_f()) != null && !doorInfos.isEmpty()) {
            Festival f = new Festival();
            for (VillageDoorInfo doorInfo : doorInfos) {
                f.addDoorPos(doorInfo.func_179856_e());
            }
            HashSet<BlockPos> hashTest = new HashSet<BlockPos>(f.getDoorPositions());
            for (Festival currentFestival : this.currentFestivals) {
                for (BlockPos p : currentFestival.doorPositions) {
                    if (!hashTest.contains(p)) continue;
                    return 1;
                }
            }
            this.addFestival(f);
            return 2;
        }
        return 0;
    }

    private void addFestival(Festival f) {
        this.currentFestivals.add(f);
        this.func_76185_a();
    }

    public static FestivalHandler get(World worldObj) {
        FestivalHandler instance = (FestivalHandler)worldObj.getPerWorldStorage().func_75742_a(FestivalHandler.class, ID);
        if (instance == null) {
            instance = new FestivalHandler();
            worldObj.getPerWorldStorage().func_75745_a(ID, (WorldSavedData)instance);
        }
        return instance;
    }

    public void tick(World worldObj) {
        long time = worldObj.func_72820_D();
        boolean celebrationTime = time > 14000L & time < 20000L;
        Iterator<Festival> iterator = this.currentFestivals.iterator();
        while (iterator.hasNext()) {
            ItemStack rocket;
            BlockPos randomPosition;
            boolean midnight;
            boolean firework = false;
            Festival festival = iterator.next();
            if (festival.getState() == Festival.STATE.SCHEDULED && celebrationTime) {
                festival.setActive();
                firework = true;
                this.func_76185_a();
            } else if (festival.getState() == Festival.STATE.ACTIVE && !celebrationTime) {
                iterator.remove();
                this.func_76185_a();
            } else if (festival.getState() == Festival.STATE.ACTIVE && celebrationTime) {
                firework = true;
            }
            if (!firework) continue;
            List<BlockPos> doorPositions = festival.getDoorPositions();
            if (time == 14001L) {
                MessageUtil.sendToAllWatchingPos(worldObj, doorPositions.get(0), (Packet)new SPacketChat((ITextComponent)new TextComponentTranslation("festival.celebrating", new Object[0]), ChatType.SYSTEM));
            }
            boolean bl = midnight = Math.abs(time - 18000L) < 300L;
            if (time == 18000L) {
                for (BlockPos pos : doorPositions) {
                    ItemStack rocket2;
                    if (!worldObj.func_175667_e(pos) || !worldObj.func_175636_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 256.0) || (rocket2 = this.getRandomFirework()).func_190926_b()) continue;
                    BlockPos topPos = worldObj.func_175672_r(pos);
                    EntityFireworkRocket entity = new EntityFireworkRocket(worldObj, (double)((float)topPos.func_177958_n() + rng.nextFloat()), (double)(topPos.func_177956_o() + 1), (double)((float)topPos.func_177952_p() + rng.nextFloat()), rocket2);
                    worldObj.func_72838_d((Entity)entity);
                }
                continue;
            }
            if (doorPositions.isEmpty()) continue;
            double d = rng.nextFloat();
            double d2 = midnight ? 0.1 : 0.05;
            if (!(d < d2) || !worldObj.func_175667_e(randomPosition = doorPositions.get(rng.nextInt(doorPositions.size()))) || !worldObj.func_175636_b((double)randomPosition.func_177958_n(), (double)randomPosition.func_177956_o(), (double)randomPosition.func_177952_p(), 256.0) || (rocket = this.getRandomFirework()).func_190926_b()) continue;
            BlockPos pos = worldObj.func_175672_r(randomPosition);
            EntityFireworkRocket entity = new EntityFireworkRocket(worldObj, (double)((float)pos.func_177958_n() + rng.nextFloat()), (double)(pos.func_177956_o() + 1), (double)((float)pos.func_177952_p() + rng.nextFloat()), rocket);
            worldObj.func_72838_d((Entity)entity);
        }
    }

    private ItemStack getRandomFirework() {
        String[] possibleCareers = new String[]{"farmer", "fisherman", "shepherd", "fletcher", "librarian", "cartographer", "cleric", "armor", "weapon", "tool", "butcher", "leather", "nitwit", "purple"};
        String name = possibleCareers[rng.nextInt(possibleCareers.length)];
        ItemStack rocket = new ItemStack(Items.field_151152_bP);
        String json = null;
        if (name.equals("farmer")) {
            json = "{Fireworks:{Flight:2,Explosions:[{Type:0,Flicker:0,Trail:1,Colors:[I;5320730,14602026],FadeColors:[I;3887386,4312372]}]}}";
        } else if (name.equals("fisherman")) {
            json = "{Fireworks:{Flight:2,Explosions:[{Type:1,Flicker:0,Trail:1,Colors:[I;2437522,2651799],FadeColors:[I;2437522,2651799,6719955]}]}}";
        } else if (name.equals("shepherd")) {
            json = "{Fireworks:{Flight:1,Explosions:[{Type:3,Flicker:0,Trail:0,Colors:[I;11250603],FadeColors:[I;15790320]}]}}";
        } else if (name.equals("fletcher")) {
            json = "{Fireworks:{Flight:3,Explosions:[{Type:0,Flicker:1,Trail:0,Colors:[I;1973019,15790320],FadeColors:[I;1973019,15790320]}]}}";
        } else if (name.equals("librarian")) {
            json = "{Fireworks:{Flight:2,Explosions:[{Type:2,Flicker:0,Trail:1,Colors:[I;5320730,15435844],FadeColors:[I;11250603,15790320]}]}}";
        } else if (name.equals("cartographer")) {
            json = "{Fireworks:{Flight:3,Explosions:[{Type:1,Flicker:1,Trail:1,Colors:[I;15435844],FadeColors:[I;11743532,3887386,5320730,2437522]}]}}";
        } else if (name.equals("cleric")) {
            json = "{Fireworks:{Flight:2,Explosions:[{Type:4,Flicker:0,Trail:1,Colors:[I;15790320],FadeColors:[I;15790320]}]}}";
        } else if (name.equals("armor")) {
            json = "{Fireworks:{Flight:2,Explosions:[{Type:0,Flicker:1,Trail:0,Colors:[I;5320730,14602026],FadeColors:[]}]}}";
        } else if (name.equals("weapon")) {
            json = "{Fireworks:{Flight:2,Explosions:[{Type:4,Flicker:1,Trail:0,Colors:[I;11743532,15790320],FadeColors:[]}]}}";
        } else if (name.equals("tool")) {
            json = "{Fireworks:{Flight:2,Explosions:[{Type:0,Flicker:1,Trail:0,Colors:[I;3887386,15790320],FadeColors:[]}]}}";
        } else if (name.equals("butcher")) {
            json = "{Fireworks:{Flight:3,Explosions:[{Type:3,Flicker:0,Trail:0,Colors:[I;11743532,14188952],FadeColors:[]}]}}";
        } else if (name.equals("leather")) {
            json = "{Fireworks:{Flight:1,Explosions:[{Type:4,Flicker:0,Trail:1,Colors:[I;5320730],FadeColors:[]}]}}";
        } else if (name.equals("nitwit")) {
            json = "{Fireworks:{Flight:2,Explosions:[{Type:1,Flicker:0,Trail:1,Colors:[I;11743532,3887386,2437522,4312372,14602026,15790320],FadeColors:[]}]}}";
        } else if (name.equals("purple")) {
            json = "{Fireworks:{Flight:3,Explosions:[{Type:4,Flicker:1,Trail:1,Colors:[I;8073150,12801229],FadeColors:[I;11743532]}]}}";
        }
        if (json != null) {
            try {
                rocket.func_77982_d(JsonToNBT.func_180713_a((String)json));
            }
            catch (NBTException e) {
                e.printStackTrace();
                return ItemStack.field_190927_a;
            }
            return rocket;
        }
        return ItemStack.field_190927_a;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("festivals", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            Festival f = new Festival();
            f.deserializeNBT(compound);
            this.currentFestivals.add(f);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (Festival f : this.currentFestivals) {
            list.func_74742_a((NBTBase)f.serializeNBT());
        }
        compound.func_74782_a("festivals", (NBTBase)list);
        return compound;
    }
}

