/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.entitys;

import java.util.Random;
import lumien.randomthings.config.Numbers;
import lumien.randomthings.item.ItemIngredient;
import lumien.randomthings.item.ModItems;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntitySpirit
extends EntityFlying {
    private BlockPos spawnPosition;
    Random rng = new Random();
    int changePositionCounter = 0;
    int spiritAge;

    public EntitySpirit(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.25f, 0.25f);
        this.field_70765_h = new SpiritMoveHelper(this);
    }

    public EntitySpirit(World worldIn, double posX, double posY, double posZ) {
        this(worldIn);
        this.func_70107_b(posX, posY, posZ);
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.spiritAge = tagCompund.func_74762_e("spiritAge");
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("spiritAge", this.spiritAge);
    }

    public void func_70636_d() {
        super.func_70636_d();
        ++this.spiritAge;
        if (!this.field_70170_p.field_72995_K && this.spiritAge > Numbers.SPIRIT_LIFETIME) {
            this.func_174812_G();
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        EntityPlayer player;
        ItemStack equipped;
        EntityDamageSource eds;
        if (source instanceof EntityDamageSource && (eds = (EntityDamageSource)source).func_76355_l().equals("player") && eds.func_76346_g() instanceof EntityPlayer && (equipped = (player = (EntityPlayer)eds.func_76346_g()).func_184614_ca()) != null && equipped.func_77973_b() == ModItems.spectreSword) {
            return super.func_70097_a(source, amount);
        }
        if (!source.func_82725_o() && source != DamageSource.field_76380_i && !source.func_180136_u()) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1.0);
    }

    public void func_70653_a(Entity entity, float p_70653_2_, double p_70653_3_, double p_70653_5_) {
    }

    protected void func_82167_n(Entity entityIn) {
    }

    protected void func_85033_bc() {
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.spawnPosition == null) {
            this.spawnPosition = this.func_180425_c();
        }
        ++this.changePositionCounter;
        if (this.changePositionCounter >= 60) {
            this.changePositionCounter = 0;
            BlockPos newTarget = null;
            for (int trys = 0; newTarget == null && trys < 10; ++trys) {
                int modZ;
                int modY;
                int modX = this.rng.nextInt(5) - 2;
                BlockPos modPos = this.spawnPosition.func_177982_a(modX, modY = this.rng.nextInt(3), modZ = this.rng.nextInt(5) - 2);
                if (!this.field_70170_p.func_175623_d(modPos)) continue;
                newTarget = modPos;
            }
            if (newTarget != null) {
                this.field_70765_h.func_75642_a((double)newTarget.func_177958_n(), (double)newTarget.func_177956_o(), (double)newTarget.func_177952_p(), 0.02);
            }
        }
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        if (wasRecentlyHit) {
            int i = 1;
            if (this.field_70146_Z.nextInt(5) == 0) {
                ++i;
            }
            for (int j = 0; j < i; ++j) {
                this.func_70099_a(new ItemStack((Item)ModItems.ingredients, 1, ItemIngredient.INGREDIENT.ECTO_PLASM.id), 0.0f);
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && (this.field_70142_S != this.field_70165_t || this.field_70137_T != this.field_70163_u || this.field_70136_U != this.field_70161_v) && Math.random() < 0.5) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, this.field_70165_t, this.field_70163_u, this.field_70161_v, Math.random() * 0.02 - 0.01, Math.random() * 0.02, Math.random() * 0.02 - 0.01, new int[0]);
        }
    }

    static class SpiritMoveHelper
    extends EntityMoveHelper {
        private EntitySpirit parentEntity;
        private int courseChangeCooldown;

        public SpiritMoveHelper(EntitySpirit parentEntity) {
            super((EntityLiving)parentEntity);
            this.parentEntity = parentEntity;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - this.parentEntity.field_70165_t;
                double d1 = this.field_75647_c - this.parentEntity.field_70163_u;
                double d2 = this.field_75644_d - this.parentEntity.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.isNotColliding(this.field_75646_b, this.field_75647_c, this.field_75644_d, d3 = (double)MathHelper.func_76133_a((double)d3)) && d3 > 0.2) {
                    this.parentEntity.field_70159_w += d0 / d3 * 0.01;
                    this.parentEntity.field_70181_x += d1 / d3 * 0.01;
                    this.parentEntity.field_70179_y += d2 / d3 * 0.01;
                } else {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                }
            }
        }

        private boolean isNotColliding(double p_179926_1_, double p_179926_3_, double p_179926_5_, double p_179926_7_) {
            double d0 = (p_179926_1_ - this.parentEntity.field_70165_t) / p_179926_7_;
            double d1 = (p_179926_3_ - this.parentEntity.field_70163_u) / p_179926_7_;
            double d2 = (p_179926_5_ - this.parentEntity.field_70161_v) / p_179926_7_;
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            int i = 1;
            while ((double)i < p_179926_7_) {
                if (!this.parentEntity.field_70170_p.func_184144_a((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_72317_d(d0, d1, d2)).isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public void func_75642_a(double x, double y, double z, double speedIn) {
            super.func_75642_a(x, y, z, speedIn);
        }
    }
}

