/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.util;

import ic2.core.block.base.tile.TileEntityMachine;
import ic2.core.fluid.IC2Tank;
import ic2.core.util.misc.FluidHelper;
import ic2.core.util.misc.StackUtil;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;

public class StackHelper {
    public static void doFluidContainerThings(TileEntityMachine tile, IC2Tank tank, int slotInput, int slotOutput) {
        if (!StackHelper.isSlotEmpty(tile, slotInput)) {
            Tuple filled;
            boolean didEmpty;
            ItemStack emptyStack = FluidUtil.tryEmptyContainer((ItemStack)tile.getStackInSlot(slotInput), (IFluidHandler)tank, (int)(tank.getCapacity() - tank.getFluidAmount()), null, (boolean)false).getResult();
            boolean bl = didEmpty = FluidUtil.tryEmptyContainer((ItemStack)tile.getStackInSlot(slotInput), (IFluidHandler)tank, (int)(tank.getCapacity() - tank.getFluidAmount()), null, (boolean)false) != FluidActionResult.FAILURE;
            if (!StackHelper.isTankFull(tank) && !StackHelper.isSlotFull(tile, slotOutput) && StackHelper.canOutputStack(tile, emptyStack, slotOutput) && didEmpty) {
                FluidUtil.tryEmptyContainer((ItemStack)tile.getStackInSlot(slotInput), (IFluidHandler)tank, (int)(tank.getCapacity() - tank.getFluidAmount()), null, (boolean)true);
                if (StackHelper.isSlotEmpty(tile, slotOutput)) {
                    tile.setStackInSlot(slotOutput, emptyStack);
                } else {
                    tile.getStackInSlot(slotOutput).func_190917_f(1);
                }
                tile.getStackInSlot(slotInput).func_190918_g(1);
            }
            if ((filled = FluidHelper.fillContainer((ItemStack)tile.getStackInSlot(slotInput), (FluidStack)tank.getFluid(), (boolean)true, (boolean)true)) != null && StackHelper.canOutputStack(tile, (ItemStack)filled.func_76341_a(), slotOutput)) {
                if (StackHelper.isSlotEmpty(tile, slotOutput)) {
                    tile.setStackInSlot(slotOutput, (ItemStack)filled.func_76341_a());
                } else {
                    tile.getStackInSlot(slotOutput).func_190917_f(1);
                }
                tile.getStackInSlot(slotInput).func_190918_g(1);
                tank.drainInternal((FluidStack)filled.func_76340_b(), true);
            }
        }
    }

    public static boolean isTankFull(IC2Tank tank) {
        return tank.getFluidAmount() == tank.getCapacity();
    }

    public static boolean canMerge(ItemStack stack, ItemStack toCompare) {
        return StackHelper.canMerge(stack, toCompare, stack.func_77976_d());
    }

    public static boolean canMerge(ItemStack stack, ItemStack toCompare, int maxCount) {
        return StackHelper.isEqual(stack, toCompare) && toCompare.func_190916_E() + stack.func_190916_E() <= maxCount || toCompare.func_190926_b();
    }

    public static boolean isEqual(ItemStack stack, ItemStack toCompare) {
        return StackUtil.isStackEqual((ItemStack)stack, (ItemStack)toCompare, (boolean)false, (boolean)false);
    }

    public static boolean isEqualCompareOreDict(ItemStack stack, ItemStack toCompare) {
        return StackUtil.isStackEqual((ItemStack)stack, (ItemStack)toCompare, (boolean)false, (boolean)false) || StackHelper.sharesOreDict(stack, toCompare);
    }

    public static boolean sharesOreDict(ItemStack stack, ItemStack toCompare) {
        if (!stack.func_190926_b() && OreDictionary.getOreIDs((ItemStack)stack).length > 0) {
            for (int i = 0; i < OreDictionary.getOreIDs((ItemStack)stack).length; ++i) {
                if (!StackHelper.matchOreDict(toCompare, OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)stack)[i]))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canOutputStack(TileEntityMachine tile, ItemStack stack, int slot) {
        if (((ItemStack)tile.inventory.get(slot)).func_190926_b()) {
            return true;
        }
        int count = ((ItemStack)tile.inventory.get(slot)).func_190916_E();
        boolean hasRoom = count < ((ItemStack)tile.inventory.get(slot)).func_77976_d();
        return hasRoom && StackHelper.isEqual(tile.getStackInSlot(slot), stack);
    }

    public static boolean isSlotEmpty(TileEntityMachine tile, int slot) {
        return ((ItemStack)tile.inventory.get(slot)).func_190926_b();
    }

    public static boolean isSlotFull(TileEntityMachine tile, int slot) {
        if (((ItemStack)tile.inventory.get(slot)).func_190926_b()) {
            return false;
        }
        return ((ItemStack)tile.inventory.get(slot)).func_190916_E() == ((ItemStack)tile.inventory.get(slot)).func_77976_d();
    }

    public int getSlotStackCount(TileEntityMachine tile, int slot) {
        if (((ItemStack)tile.inventory.get(slot)).func_190926_b()) {
            return 0;
        }
        return tile.getStackInSlot(slot).func_190916_E();
    }

    public static List<ItemStack> mergeItems(List<ItemStack> a, List<ItemStack> b) {
        int size = b.size();
        for (int i = 0; i < size; ++i) {
            if (b.get(i).func_190926_b()) continue;
            int position = StackHelper.contains(a, b.get(i));
            if (position == -1) {
                a.add(b.get(i));
                continue;
            }
            a.get(position).func_190917_f(b.get(i).func_190916_E());
        }
        return a;
    }

    public static int contains(List<ItemStack> list, ItemStack item) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (!StackUtil.isStackEqual((ItemStack)list.get(i), (ItemStack)item)) continue;
            return i;
        }
        return -1;
    }

    public static boolean matchOreDict(ItemStack stack, String entry) {
        if (!stack.func_190926_b() && OreDictionary.getOreIDs((ItemStack)stack).length > 0) {
            for (int i = 0; i < OreDictionary.getOreIDs((ItemStack)stack).length; ++i) {
                if (!OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)stack)[i]).contains(entry)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isEqualOrSharesOreDict(ItemStack stack, ItemStack toCompare) {
        return StackHelper.isEqual(stack, toCompare) || StackHelper.sharesOreDict(stack, toCompare);
    }

    public static int containsWithSizeFuzzy(List<ItemStack> list, ItemStack item) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (!StackHelper.isEqualOrSharesOreDict(list.get(i), item) || item.func_190916_E() < list.get(i).func_190916_E()) continue;
            return i;
        }
        return -1;
    }

    public static void tryCondenseInventory(TileEntityMachine tile, int startSlot, int endSlot) {
        for (int i = startSlot; i < endSlot; ++i) {
            for (int j = startSlot; j < endSlot; ++j) {
                if (i == j) continue;
                ItemStack stack1 = (ItemStack)tile.inventory.get(i);
                ItemStack stack2 = (ItemStack)tile.inventory.get(j);
                if (!stack1.func_190926_b() && !stack2.func_190926_b() && StackHelper.isEqual(stack1, stack2) && stack1.func_190916_E() < stack1.func_77976_d()) {
                    int max = stack1.func_77976_d() - stack1.func_190916_E();
                    int available = stack2.func_190916_E();
                    int size = MathHelper.func_76125_a((int)available, (int)1, (int)max);
                    stack1.func_190917_f(size);
                    stack2.func_190918_g(size);
                }
                if (!stack2.func_190926_b() || stack1.func_190926_b() || j >= i) continue;
                tile.inventory.set(j, (Object)stack1.func_77946_l());
                tile.inventory.set(i, (Object)ItemStack.field_190927_a);
            }
        }
    }
}

