/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import forestry.api.core.ForestryAPI;
import forestry.api.farming.IFarmRegistry;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.MoistenerFuel;
import forestry.api.modules.ForestryModule;
import forestry.api.recipes.RecipeManagers;
import forestry.core.ModuleCore;
import forestry.core.ModuleFluids;
import forestry.core.fluids.Fluids;
import forestry.core.items.ItemRegistryCore;
import forestry.core.recipes.RecipeUtil;
import forestry.farming.logic.farmables.FarmableAgingCrop;
import forestry.modules.ModuleHelper;
import forestry.plugins.CompatPlugin;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

@ForestryModule(containerID="forestry_compat", moduleID="harvestcraft", name="HarvestCraft", author="Nirek", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.harvestcraft.description")
public class PluginHarvestCraft
extends CompatPlugin {
    public PluginHarvestCraft() {
        super("HarvestCraft", "harvestcraft");
    }

    @Override
    public void registerRecipes() {
        Block fruitBlock;
        boolean farmingModuleEnabled = ModuleHelper.isEnabled("farming");
        ImmutableList berries = ImmutableList.of((Object)"cranberry", (Object)"blackberry", (Object)"blueberry", (Object)"raspberry", (Object)"strawberry");
        ImmutableList fruits = ImmutableList.of((Object)"pineapple", (Object)"cactusfruit", (Object)"cantaloupe", (Object)"grape", (Object)"kiwi", (Object)"chilipepper");
        ImmutableList treeFruits = ImmutableList.of((Object)"banana", (Object)"dragonfruit", (Object)"lemon", (Object)"lime", (Object)"mango", (Object)"orange", (Object)"papaya", (Object)"peach", (Object)"pear", (Object)"plum", (Object)"pomegranate", (Object)"starfruit", (Object[])new String[]{"apricot", "date", "fig", "grapefruit", "persimmon", "avocado", "coconut", "durian"});
        ImmutableList trees = ImmutableList.of((Object)"nutmeg", (Object)"olive", (Object)"peppercorn");
        ImmutableList treesSpecial = ImmutableList.of((Object)"cinnamon", (Object)"maple", (Object)"paperbark", (Object)"vanillabean", (Object)"apple");
        ImmutableList herbs = ImmutableList.of((Object)"garlic");
        ImmutableList spices = ImmutableList.of((Object)"ginger", (Object)"spiceleaf");
        ImmutableList vegetables = ImmutableList.of((Object)"asparagus", (Object)"bean", (Object)"beet", (Object)"broccoli", (Object)"cauliflower", (Object)"celery", (Object)"leek", (Object)"lettuce", (Object)"onion", (Object)"parsnip", (Object)"radish", (Object)"rutabaga", (Object[])new String[]{"scallion", "soybean", "sweetpotato", "turnip", "whitemushroom", "artichoke", "bellpepper", "brusselsprout", "cabbage", "corn", "cucumber", "eggplant", "okra", "peas", "rhubarb", "seaweed", "tomato", "wintersquash", "zucchini", "bambooshoot", "spinach"});
        ImmutableList grains = ImmutableList.of((Object)"barley", (Object)"oats", (Object)"rye");
        ImmutableList cropNuts = ImmutableList.of((Object)"peanut");
        ImmutableList nuts = ImmutableList.of((Object)"walnut", (Object)"almond", (Object)"cashew", (Object)"chestnut", (Object)"pecan", (Object)"pistachio", (Object)"cherry");
        ImmutableList.Builder genericCropsBuilder = ImmutableList.builder();
        genericCropsBuilder.add((Object[])new String[]{"cotton", "rice", "tealeaf", "coffeebean", "candleberry"});
        genericCropsBuilder.addAll((Iterable)herbs);
        genericCropsBuilder.addAll((Iterable)spices);
        IFarmRegistry farmRegistry = ForestryAPI.farmRegistry;
        ImmutableList genericCrops = genericCropsBuilder.build();
        ImmutableList.Builder plants = ImmutableList.builder();
        int juiceAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.apple") / 25;
        int seedamount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.seed");
        int wheatamount = ForestryAPI.activeMode.getIntegerSetting("recipe.output.compost.wheat");
        PropertyInteger plantAGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)3);
        PropertyInteger fruitAGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)2);
        juiceAmount = Math.max(juiceAmount, 1);
        Fluid juice = Fluids.JUICE.getFluid();
        Fluid seedOil = Fluids.SEED_OIL.getFluid();
        for (String berryName : berries) {
            ItemStack berry = this.getItemStack(berryName + "item");
            ItemStack berrySeed = this.getItemStack(berryName + "seeditem");
            Block berryBlock = this.getBlock("pam" + berryName + "crop");
            if (berry != null && juice != null) {
                RecipeManagers.squeezerManager.addRecipe(10, berry, new FluidStack(juice, juiceAmount));
            }
            if (berrySeed != null && seedOil != null) {
                RecipeManagers.squeezerManager.addRecipe(10, berrySeed, new FluidStack(seedOil, seedamount));
            }
            if (farmingModuleEnabled && berrySeed != null && berryBlock != null) {
                farmRegistry.registerFarmables("farmCrops", new FarmableAgingCrop(berrySeed, berryBlock, (IProperty<Integer>)plantAGE, 3, (Integer)0));
            }
            plants.add((Object)berryName);
        }
        juiceAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.apple");
        for (String fruitName : fruits) {
            ItemStack fruit = this.getItemStack(fruitName + "item");
            ItemStack fruitSeed = this.getItemStack(fruitName + "seeditem");
            Block fruitBlock2 = this.getBlock("pam" + fruitName + "crop");
            if (fruit != null && juice != null) {
                RecipeManagers.squeezerManager.addRecipe(10, fruit, new FluidStack(juice, juiceAmount));
            }
            if (fruitSeed != null && seedOil != null) {
                RecipeManagers.squeezerManager.addRecipe(10, fruitSeed, new FluidStack(seedOil, seedamount));
            }
            if (farmingModuleEnabled && fruitSeed != null && fruitBlock2 != null) {
                farmRegistry.registerFarmables("farmCrops", new FarmableAgingCrop(fruitSeed, fruitBlock2, (IProperty<Integer>)plantAGE, 3, (Integer)0));
            }
            plants.add((Object)fruitName);
        }
        juiceAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.apple") / 2;
        juiceAmount = Math.max(juiceAmount, 1);
        for (String vegetableName : vegetables) {
            ItemStack vegetable = this.getItemStack(vegetableName + "item");
            ItemStack vegetableSeed = this.getItemStack(vegetableName + "seeditem");
            Block vegetableBlock = this.getBlock("pam" + vegetableName + "crop");
            if (vegetable != null && juice != null) {
                RecipeManagers.squeezerManager.addRecipe(10, vegetable, new FluidStack(juice, juiceAmount));
            }
            if (vegetableSeed != null && seedOil != null) {
                RecipeManagers.squeezerManager.addRecipe(10, vegetableSeed, new FluidStack(seedOil, seedamount));
            }
            if (farmingModuleEnabled && vegetableSeed != null && vegetableBlock != null) {
                farmRegistry.registerFarmables("farmCrops", new FarmableAgingCrop(vegetableSeed, vegetableBlock, (IProperty<Integer>)plantAGE, 3, (Integer)0));
            }
            plants.add((Object)vegetableName);
        }
        ItemRegistryCore coreItems = ModuleCore.getItems();
        for (String grainName : grains) {
            ItemStack grain = this.getItemStack(grainName + "item");
            ItemStack grainSeed = this.getItemStack(grainName + "seeditem");
            Block grainBlock = this.getBlock("pam" + grainName + "crop");
            if (grain != null && wheatamount > 0) {
                RecipeUtil.addRecipe("pam_compost_" + grainName, coreItems.compost.getItemStack(wheatamount), " X ", "X#X", " X ", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), grain);
                FuelManager.moistenerResource.put(grain, new MoistenerFuel(grain, coreItems.mouldyWheat.getItemStack(), 0, 300));
            }
            if (grainSeed != null && seedOil != null) {
                RecipeManagers.squeezerManager.addRecipe(10, grainSeed, new FluidStack(seedOil, seedamount));
                RecipeManagers.moistenerManager.addRecipe(grainSeed, new ItemStack((Block)Blocks.field_150391_bh), 5000);
            }
            if (farmingModuleEnabled && grainSeed != null && grainBlock != null) {
                farmRegistry.registerFarmables("farmCrops", new FarmableAgingCrop(grainSeed, grainBlock, (IProperty<Integer>)plantAGE, 3, (Integer)0));
            }
            plants.add((Object)grainName);
        }
        for (String treeFruitName : treeFruits) {
            ItemStack treeFruit = this.getItemStack(treeFruitName + "item");
            Block treeFruitBlock = this.getBlock("pam" + treeFruitName);
            if (farmingModuleEnabled && treeFruitBlock != null) {
                farmRegistry.registerFarmables("farmOrchard", new FarmableAgingCrop(ItemStack.field_190927_a, treeFruitBlock, (IProperty<Integer>)fruitAGE, 2, (Integer)0));
            }
            if (treeFruit != null && juice != null) {
                RecipeManagers.squeezerManager.addRecipe(10, treeFruit, new FluidStack(juice, juiceAmount));
            }
            plants.add((Object)treeFruitName);
        }
        for (String treeName : trees) {
            fruitBlock = this.getBlock("pam" + treeName);
            if (farmingModuleEnabled && fruitBlock != null) {
                farmRegistry.registerFarmables("farmOrchard", new FarmableAgingCrop(ItemStack.field_190927_a, fruitBlock, (IProperty<Integer>)fruitAGE, 2, (Integer)0));
            }
            plants.add((Object)treeName);
        }
        for (String treeName : treesSpecial) {
            fruitBlock = this.getBlock("pam" + treeName);
            if (!farmingModuleEnabled || fruitBlock == null) continue;
            farmRegistry.registerFarmables("farmOrchard", new FarmableAgingCrop(ItemStack.field_190927_a, fruitBlock, (IProperty<Integer>)fruitAGE, 2, (Integer)0));
        }
        for (String cropName : genericCrops) {
            String seedPrefix = cropName;
            if (seedPrefix.equals("tealeaf")) {
                seedPrefix = "tea";
            }
            if (seedPrefix.equals("coffeebean")) {
                seedPrefix = "coffee";
            }
            UnmodifiableIterator genericCropSeed = this.getItemStack(seedPrefix + "seeditem");
            Block genericCropBlock = this.getBlock("pam" + cropName + "crop");
            if (genericCropSeed != null && seedOil != null) {
                RecipeManagers.squeezerManager.addRecipe(10, (ItemStack)genericCropSeed, new FluidStack(seedOil, seedamount));
            }
            if (farmingModuleEnabled && genericCropSeed != null && genericCropBlock != null) {
                farmRegistry.registerFarmables("farmCrops", new FarmableAgingCrop((ItemStack)genericCropSeed, genericCropBlock, (IProperty<Integer>)plantAGE, 3, (Integer)0));
            }
            plants.add((Object)cropName);
        }
        ItemStack mustardCropSeed = this.getItemStack("mustardseeditem");
        Block mustardCropBlock = this.getBlock("pammustardseedscrop");
        ItemStack mustardFruit = this.getItemStack("mustardseedsitem");
        if (mustardCropSeed != null && seedOil != null) {
            RecipeManagers.squeezerManager.addRecipe(10, mustardCropSeed, new FluidStack(seedOil, seedamount));
        }
        if (farmingModuleEnabled && mustardCropSeed != null && mustardCropBlock != null) {
            farmRegistry.registerFarmables("farmCrops", new FarmableAgingCrop(mustardCropSeed, mustardCropBlock, (IProperty<Integer>)plantAGE, 3, (Integer)0));
        }
        if (mustardFruit != null) {
            RecipeUtil.addFermenterRecipes(mustardFruit, ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.wheat"), Fluids.BIOMASS);
        }
        for (String plantName : plants.build()) {
            ItemStack plant = this.getItemStack(plantName + "item");
            if (plant == null) continue;
            RecipeUtil.addFermenterRecipes(plant, ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.wheat"), Fluids.BIOMASS);
        }
        for (String cropnutName : cropNuts) {
            ItemStack cropnut = this.getItemStack(cropnutName + "item");
            ItemStack cropnutSeed = this.getItemStack(cropnutName + "seeditem");
            Block cropnutBlock = this.getBlock("pam" + cropnutName + "crop");
            if (cropnutSeed != null && seedOil != null) {
                RecipeManagers.squeezerManager.addRecipe(10, cropnutSeed, new FluidStack(seedOil, seedamount));
            }
            if (farmingModuleEnabled && cropnutSeed != null && cropnutBlock != null) {
                farmRegistry.registerFarmables("farmCrops", new FarmableAgingCrop(cropnutSeed, cropnutBlock, (IProperty<Integer>)plantAGE, 3, (Integer)0));
            }
            if (cropnut == null || seedOil == null) continue;
            RecipeManagers.squeezerManager.addRecipe(20, cropnut, new FluidStack(seedOil, 12 * seedamount));
        }
        for (String nutName : nuts) {
            ItemStack nut = this.getItemStack(nutName + "item");
            Block nutBlock = this.getBlock("pam" + nutName);
            if (farmingModuleEnabled && nutBlock != null) {
                farmRegistry.registerFarmables("farmOrchard", new FarmableAgingCrop(ItemStack.field_190927_a, nutBlock, (IProperty<Integer>)fruitAGE, 2, (Integer)0));
            }
            if (nut == null || seedOil == null) continue;
            RecipeManagers.squeezerManager.addRecipe(20, nut, new FluidStack(seedOil, 15 * seedamount));
        }
        if (ModuleHelper.isEnabled("apiculture")) {
            ItemStack hcBeeswaxItem;
            ItemStack hcHoneyItem = this.getItemStack("honeyitem");
            FluidStack honey = Fluids.FOR_HONEY.getFluid(100);
            if (hcHoneyItem != null && honey != null) {
                RecipeManagers.squeezerManager.addRecipe(10, hcHoneyItem, honey);
            }
            if ((hcBeeswaxItem = this.getItemStack("beeswaxitem")) != null) {
                RecipeUtil.addRecipe("pam_wax_capsule", ModuleFluids.getItems().waxCapsuleEmpty.getItemStack(ForestryAPI.activeMode.getIntegerSetting("recipe.output.capsule")), "XXX ", Character.valueOf('X'), hcBeeswaxItem);
            }
        }
    }
}

