/*
 * Decompiled with CFR 0.152.
 */
package forestry.book.gui;

import forestry.api.book.IBookCategory;
import forestry.api.book.IForesterBook;
import forestry.book.gui.GuiForesterBook;
import forestry.book.gui.GuiForestryBookEntries;
import forestry.book.gui.buttons.GuiButtonBookCategory;
import forestry.core.gui.Drawable;
import forestry.core.utils.Translator;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiForestryBookCategories
extends GuiForesterBook {
    public static final Drawable LOGO = new Drawable(new ResourceLocation("forestry", "textures/gui/almanac/logo.png"), 0, 0, 256, 58, 256, 58);

    public GuiForestryBookCategories(IForesterBook book) {
        super(book);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int x = 0;
        int y = 0;
        for (IBookCategory category : this.book.getCategories()) {
            if (category.getEntries().isEmpty()) continue;
            this.field_146292_n.add(new GuiButtonBookCategory(y * 3 + x, this.guiLeft + 16 + x * 36, this.guiTop + 25 + y * 36, category));
            if (++x != 3) continue;
            ++y;
            x = 0;
        }
    }

    @Override
    protected boolean hasButtons() {
        return false;
    }

    @Override
    protected void drawText() {
        this.func_73732_a(this.field_146289_q, TextFormatting.UNDERLINE + Translator.translateToLocal("for.gui.book.about.title"), this.guiLeft + 132 + 52, this.guiTop + 12, 0xD3D3D3);
        String about = Translator.translateToLocal("for.gui.book.about");
        this.field_146289_q.func_78279_b(about, this.guiLeft + 132, this.guiTop + 25, 108, 0);
        this.field_146289_q.func_78276_b(Translator.translateToLocal("for.gui.book.about.author"), this.guiLeft + 132, this.guiTop + 25 + this.field_146289_q.func_78267_b(about, 108), 0);
        LOGO.draw(this.guiLeft + 132, this.guiTop + 25 + 110, 108, 24);
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof GuiButtonBookCategory) {
            GuiButtonBookCategory buttonCategory = (GuiButtonBookCategory)button;
            this.field_146297_k.func_147108_a((GuiScreen)new GuiForestryBookEntries(this.book, buttonCategory.category));
        }
    }

    @Override
    protected String getTitle() {
        return Translator.translateToLocal("for.gui.book.categories");
    }
}

