/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.wsd;

import io.github.phantamanta44.libnine.LibNine;
import io.github.phantamanta44.libnine.Virtue;
import io.github.phantamanta44.libnine.wsd.IWSDIdentity;
import io.github.phantamanta44.libnine.wsd.L9WSD;
import io.github.phantamanta44.libnine.wsd.WSDGlobalIdentity;
import io.github.phantamanta44.libnine.wsd.WSDIdentity;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class WSDManager {
    private final Virtue virtue;
    private final Map<IWSDIdentity<? extends L9WSD>, Function<World, ? extends L9WSD>> factoryMap;

    public WSDManager(Virtue virtue) {
        this.virtue = virtue;
        this.factoryMap = new HashMap<IWSDIdentity<? extends L9WSD>, Function<World, ? extends L9WSD>>();
    }

    public <T extends L9WSD> void register(WSDIdentity<T> identity, Function<World, T> factory) {
        this.factoryMap.put(identity, factory);
    }

    public <T extends L9WSD> void register(WSDGlobalIdentity<T> identity, Supplier<T> factory) {
        this.factoryMap.put(identity, w -> (L9WSD)factory.get());
    }

    public <T extends L9WSD> T get(WSDIdentity<T> identity, World world) {
        return (T)this.get0(identity, world);
    }

    public <T extends L9WSD> T get(WSDGlobalIdentity<T> identity) {
        return (T)this.get0(identity, LibNine.PROXY.getAnySidedWorld());
    }

    private L9WSD get0(IWSDIdentity<?> identity, World world) {
        String identifier = this.getIdentifier(identity);
        L9WSD data = (L9WSD)world.getPerWorldStorage().func_75742_a(identity.getType(), identifier);
        if (data == null) {
            data = this.factoryMap.get(identity).apply(world);
            world.getPerWorldStorage().func_75745_a(identifier, (WorldSavedData)data);
        }
        return data;
    }

    private String getIdentifier(IWSDIdentity<?> identity) {
        return String.format("%s:%s_%s", this.virtue.getModId(), identity.getPrefix(), identity.getIdentifier());
    }
}

