/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.world;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.minecraft.util.math.BlockPos;

public class CuboidIterator
implements Iterator<BlockPos> {
    private int minX;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;
    private int nextX;
    private int nextY;
    private int nextZ;

    public CuboidIterator(BlockPos min, BlockPos max) {
        this.minX = min.func_177958_n();
        this.minZ = min.func_177952_p();
        this.maxX = max.func_177958_n();
        this.maxY = max.func_177956_o();
        this.maxZ = max.func_177952_p();
        this.nextX = this.minX;
        this.nextY = min.func_177956_o();
        this.nextZ = this.minZ;
    }

    @Override
    public boolean hasNext() {
        return this.nextX <= this.maxX && this.nextY <= this.maxY && this.nextZ <= this.maxZ;
    }

    @Override
    public BlockPos next() {
        if (this.hasNext()) {
            BlockPos nextPos = new BlockPos(this.nextX, this.nextY, this.nextZ);
            if (++this.nextX > this.maxX) {
                this.nextX = this.minX;
                if (++this.nextZ > this.maxZ) {
                    this.nextZ = this.minZ;
                    ++this.nextY;
                }
            }
            return nextPos;
        }
        throw new NoSuchElementException();
    }
}

