/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla;

import cubex2.cs4.api.WrappedBlockState;
import cubex2.cs4.plugins.vanilla.block.BlockRegistry;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;

public class WrappedBlockStateImpl
implements WrappedBlockState {
    private final ResourceLocation block;
    private final List<Tuple<String, String>> properties;

    public WrappedBlockStateImpl(ResourceLocation block, List<Tuple<String, String>> properties) {
        this.block = block;
        this.properties = properties;
    }

    @Override
    public IBlockState createState() {
        Block block = this.getBlock();
        if (block != null) {
            IBlockState state = block.func_176223_P();
            for (Tuple<String, String> tuple : this.properties) {
                String name = (String)tuple.func_76341_a();
                Optional<IProperty> prop = this.getProperty(state, name);
                if (!prop.isPresent()) continue;
                IProperty property = prop.get();
                state = state.func_177226_a(property, (Comparable)property.func_185929_b((String)tuple.func_76340_b()).get());
            }
            return state;
        }
        return null;
    }

    @Nullable
    private Block getBlock() {
        if (Block.field_149771_c.func_148741_d((Object)this.block)) {
            return (Block)Block.field_149771_c.func_82594_a((Object)this.block);
        }
        if (BlockRegistry.INSTANCE.contains(this.block)) {
            return BlockRegistry.INSTANCE.get(this.block);
        }
        return null;
    }

    private Optional<IProperty> getProperty(IBlockState state, String name) {
        for (IProperty key : state.func_177227_a()) {
            if (!key.func_177701_a().equals(name)) continue;
            return Optional.of(key);
        }
        return Optional.empty();
    }
}

