/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla;

import com.google.common.collect.Maps;
import cubex2.cs4.plugins.vanilla.ContentTileEntityBase;
import cubex2.cs4.util.AsmHelper;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class TileEntityRegistry
implements Opcodes {
    private static final Map<ResourceLocation, Entry> map = Maps.newHashMap();

    public static void register(ContentTileEntityBase content) {
        Class<? extends TileEntity> clazz = TileEntityRegistry.createClass(content.getTemplateClass(), content.getKey().toString());
        map.put(content.getKey(), new Entry(clazz, content));
        GameRegistry.registerTileEntity(clazz, (String)content.getKey().toString());
    }

    public static ContentTileEntityBase getContent(ResourceLocation id) {
        return TileEntityRegistry.map.get((Object)id).content;
    }

    @Nullable
    public static TileEntity createTileEntity(ResourceLocation id) {
        try {
            return TileEntityRegistry.map.get((Object)id).clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    static Class<? extends TileEntity> createClass(Class<? extends TileEntity> template, String contentId) {
        String className = template.getName().replace('.', '/') + "_" + contentId.replace(":", "_");
        byte[] byteCode = TileEntityRegistry.generateClass(template, className, contentId);
        return AsmHelper.createClassFromBytes(className, byteCode);
    }

    private static byte[] generateClass(Class<? extends TileEntity> baseClass, String className, String contentId) {
        ClassWriter cw = new ClassWriter(0);
        cw.visit(51, 33, className, null, Type.getInternalName(baseClass), null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn((Object)contentId);
        mv.visitMethodInsn(183, Type.getInternalName(baseClass), "<init>", "(Ljava/lang/String;)V", false);
        mv.visitInsn(177);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
        return cw.toByteArray();
    }

    private static class Entry {
        final Class<? extends TileEntity> clazz;
        final ContentTileEntityBase content;

        public Entry(Class<? extends TileEntity> clazz, ContentTileEntityBase content) {
            this.clazz = clazz;
            this.content = content;
        }
    }
}

