/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla;

import com.google.common.collect.Lists;
import cubex2.cs4.api.ContentHelper;
import cubex2.cs4.api.InitPhase;
import cubex2.cs4.api.RecipeInput;
import cubex2.cs4.api.WrappedFluidStack;
import cubex2.cs4.data.SimpleContent;
import cubex2.cs4.plugins.vanilla.crafting.MachineManager;
import cubex2.cs4.plugins.vanilla.crafting.MachineRecipe;
import cubex2.cs4.plugins.vanilla.crafting.MachineRecipeOutput;
import cubex2.cs4.plugins.vanilla.crafting.MachineRecipeOutputImpl;
import cubex2.cs4.util.CollectionHelper;
import cubex2.cs4.util.ItemHelper;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class MachineRecipeImpl
extends SimpleContent
implements MachineRecipe {
    List<RecipeInput> input = Collections.emptyList();
    List<WrappedFluidStack> inputFluid = Collections.emptyList();
    List<MachineRecipeOutputImpl> output = Collections.emptyList();
    int cookTime = 0;
    ResourceLocation recipeList;
    private final transient List<FluidStack> inputFluidStacks = Lists.newArrayList();
    private final transient NonNullList<MachineRecipeOutput> outputs = NonNullList.func_191196_a();

    @Override
    public boolean matches(NonNullList<ItemStack> input, List<FluidStack> inputFluid, World world) {
        return CollectionHelper.equalsWithoutOrder(input, this.input, (t, i) -> ItemHelper.stackMatchesRecipeInput(t, i, true)) && CollectionHelper.equalsWithoutOrder(inputFluid, this.inputFluidStacks, (t, i) -> ItemHelper.fluidStackEqual(t, i, true));
    }

    @Override
    public NonNullList<MachineRecipeOutput> getOutputs() {
        return this.outputs;
    }

    @Override
    public List<RecipeInput> getRecipeInput() {
        return this.input;
    }

    @Override
    public List<FluidStack> getFluidRecipeInput() {
        return this.inputFluidStacks;
    }

    @Override
    public int getInputStacks() {
        return this.input.size();
    }

    @Override
    public int getFluidStacks() {
        return this.inputFluid.size();
    }

    @Override
    public int getCookTime() {
        return this.cookTime;
    }

    @Override
    protected void doInit(InitPhase phase, ContentHelper helper) {
        this.inputFluid.forEach(fluid -> this.inputFluidStacks.add(fluid.getFluidStack()));
        for (MachineRecipeOutputImpl recipeOutput : this.output) {
            recipeOutput.doInit(phase, helper);
            this.outputs.add((Object)recipeOutput);
        }
        MachineManager.addRecipe(this.recipeList, this);
    }

    @Override
    protected boolean isReady() {
        boolean inputItemsValid = this.input.stream().allMatch(input -> input.isOreClass() || input.isItemStack() && input.getStack().isItemLoaded());
        boolean inputFluidValid = this.inputFluid.stream().allMatch(fluid -> fluid.getFluidStack() != null);
        boolean outputValid = this.output.stream().allMatch(MachineRecipeOutputImpl::isReady);
        return inputItemsValid && inputFluidValid && outputValid;
    }
}

